/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import schemacrawler.crawl.AbstractDatabaseObject;
import schemacrawler.crawl.NotLoadedException;
import schemacrawler.schema.CheckConstraint;
import schemacrawler.schema.Column;
import schemacrawler.schema.ForeignKey;
import schemacrawler.schema.Index;
import schemacrawler.schema.PrimaryKey;
import schemacrawler.schema.Privilege;
import schemacrawler.schema.Schema;
import schemacrawler.schema.Table;
import schemacrawler.schema.TableRelationshipType;
import schemacrawler.schema.TableType;
import schemacrawler.schema.Trigger;

final class TablePartial
extends AbstractDatabaseObject
implements Table {
    private static final long serialVersionUID = -5968964551235088703L;
    private Column column;
    private ForeignKey foreignKey;

    TablePartial(Schema schema, String tableName) {
        super(schema, tableName);
    }

    TablePartial(Table table) {
        super(table.getSchema(), table.getName());
    }

    @Override
    public Collection<CheckConstraint> getCheckConstraints() {
        throw new NotLoadedException();
    }

    @Override
    public Column getColumn(String name) {
        if (this.column.getName().equals(name)) {
            return this.column;
        }
        return null;
    }

    @Override
    public List<Column> getColumns() {
        if (this.column != null) {
            return new ArrayList<Column>(Arrays.asList(this.column));
        }
        return Collections.emptyList();
    }

    @Override
    public String getColumnsListAsString() {
        throw new NotLoadedException();
    }

    @Override
    public Collection<ForeignKey> getExportedForeignKeys() {
        throw new NotLoadedException();
    }

    @Override
    public ForeignKey getForeignKey(String name) {
        if (this.foreignKey.getName().equals(name)) {
            return this.foreignKey;
        }
        return null;
    }

    @Override
    public Collection<ForeignKey> getForeignKeys() {
        if (this.foreignKey != null) {
            return new ArrayList<ForeignKey>(Arrays.asList(this.foreignKey));
        }
        return Collections.emptyList();
    }

    @Override
    public Collection<ForeignKey> getImportedForeignKeys() {
        throw new NotLoadedException();
    }

    @Override
    public Index getIndex(String name) {
        throw new NotLoadedException();
    }

    @Override
    public Collection<Index> getIndices() {
        throw new NotLoadedException();
    }

    @Override
    public PrimaryKey getPrimaryKey() {
        throw new NotLoadedException();
    }

    @Override
    public Privilege<Table> getPrivilege(String name) {
        throw new NotLoadedException();
    }

    @Override
    public Collection<Privilege<Table>> getPrivileges() {
        throw new NotLoadedException();
    }

    @Override
    public Collection<Table> getRelatedTables(TableRelationshipType tableRelationshipType) {
        throw new NotLoadedException();
    }

    @Override
    public TableType getTableType() {
        throw new NotLoadedException();
    }

    @Override
    public Trigger getTrigger(String name) {
        throw new NotLoadedException();
    }

    @Override
    public Collection<Trigger> getTriggers() {
        throw new NotLoadedException();
    }

    @Override
    public TableType getType() {
        throw new NotLoadedException();
    }

    void addColumn(Column column) {
        this.column = column;
    }

    void addForeignKey(ForeignKey foreignKey) {
        this.foreignKey = foreignKey;
    }
}

