/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import sf.util.Utility;

final class MetadataResultSet
implements AutoCloseable {
    private static final Logger LOGGER = Logger.getLogger(MetadataResultSet.class.getName());
    private static final int FETCHSIZE = 20;
    private final ResultSet results;
    private final List<String> resultSetColumns;
    private Set<String> readColumns;

    MetadataResultSet(ResultSet resultSet) throws SQLException {
        if (resultSet == null) {
            throw new IllegalArgumentException("Cannot use null results");
        }
        this.results = resultSet;
        try {
            this.results.setFetchSize(20);
        }
        catch (NullPointerException | SQLException e) {
            LOGGER.log(Level.WARNING, "Could not set fetch size", e);
        }
        ArrayList<String> resultSetColumns = new ArrayList<String>();
        try {
            ResultSetMetaData rsMetaData = resultSet.getMetaData();
            for (int i = 0; i < rsMetaData.getColumnCount(); ++i) {
                String columnName = rsMetaData.getColumnLabel(i + 1);
                if (Utility.isBlank(columnName)) {
                    columnName = rsMetaData.getColumnName(i + 1);
                }
                resultSetColumns.add(columnName.toUpperCase());
            }
        }
        catch (SQLException e) {
            LOGGER.log(Level.WARNING, "Could not get columns list");
        }
        this.resultSetColumns = Collections.unmodifiableList(resultSetColumns);
        this.readColumns = new HashSet<String>();
    }

    @Override
    public void close() throws SQLException {
        this.results.close();
    }

    Map<String, Object> getAttributes() {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        for (String columnName : this.resultSetColumns) {
            if (this.readColumns.contains(columnName)) continue;
            try {
                Object value = this.results.getObject(columnName);
                attributes.put(columnName, value);
            }
            catch (SQLException e) {
                LOGGER.log(Level.WARNING, "Could not read value for column " + columnName, e);
            }
        }
        return attributes;
    }

    boolean getBoolean(String columnName) {
        boolean value = false;
        if (this.useColumn(columnName)) {
            try {
                Object booleanValue = this.results.getObject(columnName);
                String stringBooleanValue = this.results.wasNull() || booleanValue == null ? null : String.valueOf(booleanValue);
                if (!Utility.isBlank(stringBooleanValue)) {
                    try {
                        int booleanInt = Integer.parseInt(stringBooleanValue);
                        value = booleanInt != 0;
                    }
                    catch (NumberFormatException e) {
                        value = stringBooleanValue.equalsIgnoreCase("YES") || Boolean.valueOf(stringBooleanValue) != false;
                    }
                }
            }
            catch (SQLException e) {
                LOGGER.log(Level.WARNING, "Could not read boolean value for column " + columnName, e);
            }
        }
        return value;
    }

    <E extends Enum<E>> E getEnum(String columnName, E defaultValue) {
        Object enumValue;
        String value = this.getString(columnName);
        if (value == null || defaultValue == null) {
            enumValue = defaultValue;
        } else {
            try {
                enumValue = Enum.valueOf(defaultValue.getClass(), value.toLowerCase(Locale.ENGLISH));
            }
            catch (Exception e) {
                enumValue = defaultValue;
            }
        }
        return enumValue;
    }

    int getInt(String columnName, int defaultValue) {
        int value = defaultValue;
        if (this.useColumn(columnName)) {
            try {
                value = this.results.getInt(columnName);
                if (this.results.wasNull()) {
                    value = defaultValue;
                }
            }
            catch (SQLException e) {
                LOGGER.log(Level.WARNING, "Could not read integer value for column " + columnName, e);
            }
        }
        return value;
    }

    long getLong(String columnName, long defaultValue) {
        long value = defaultValue;
        if (this.useColumn(columnName)) {
            try {
                value = this.results.getLong(columnName);
                if (this.results.wasNull()) {
                    value = defaultValue;
                }
            }
            catch (SQLException e) {
                LOGGER.log(Level.WARNING, "Could not read long value for column " + columnName, e);
            }
        }
        return value;
    }

    short getShort(String columnName, short defaultValue) {
        short value = defaultValue;
        if (this.useColumn(columnName)) {
            try {
                value = this.results.getShort(columnName);
                if (this.results.wasNull()) {
                    value = defaultValue;
                }
            }
            catch (SQLException e) {
                LOGGER.log(Level.WARNING, "Could not read short value for column " + columnName, e);
            }
        }
        return value;
    }

    String getString(String columnName) {
        String value = null;
        if (this.useColumn(columnName)) {
            try {
                value = this.results.getString(columnName);
                if (this.results.wasNull()) {
                    value = null;
                }
            }
            catch (SQLException e) {
                LOGGER.log(Level.WARNING, "Could not read string value for column " + columnName, e);
            }
        }
        return value;
    }

    boolean next() throws SQLException {
        this.readColumns = new HashSet<String>();
        return this.results.next();
    }

    private boolean useColumn(String columnName) {
        boolean useColumn;
        boolean bl = useColumn = columnName != null && this.resultSetColumns.contains(columnName);
        if (useColumn) {
            this.readColumns.add(columnName);
        }
        return useColumn;
    }
}

