/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.executable;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import schemacrawler.schema.Database;
import schemacrawler.schemacrawler.SchemaCrawlerException;
import schemacrawler.tools.executable.BaseExecutable;
import schemacrawler.tools.executable.CommandRegistry;
import schemacrawler.tools.executable.Executable;

abstract class BaseCommandChainExecutable
extends BaseExecutable {
    private static final Logger LOGGER = Logger.getLogger(BaseCommandChainExecutable.class.getName());
    private final List<Executable> executables;
    private final CommandRegistry commandRegistry = new CommandRegistry();

    protected BaseCommandChainExecutable(String command) throws SchemaCrawlerException {
        super(command);
        this.executables = new ArrayList<Executable>();
    }

    public final Executable addNext(Executable executable) {
        if (executable != null) {
            this.executables.add(executable);
        }
        return executable;
    }

    public final Executable addNext(String command) throws SchemaCrawlerException {
        try {
            Executable executable = this.commandRegistry.newExecutable(command);
            if (executable == null) {
                return executable;
            }
            executable.setSchemaCrawlerOptions(this.schemaCrawlerOptions);
            executable.setAdditionalConfiguration(this.additionalConfiguration);
            executable.setOutputOptions(this.outputOptions);
            return this.addNext(executable);
        }
        catch (Exception e) {
            throw new SchemaCrawlerException(String.format("Cannot chain executable, unknown command, %s", command));
        }
    }

    protected final void executeChain(Database database, Connection connection) throws Exception {
        if (this.executables.isEmpty()) {
            LOGGER.log(Level.INFO, "No commands to execute");
            return;
        }
        for (Executable executable : this.executables) {
            if (!(executable instanceof BaseExecutable)) continue;
            ((BaseExecutable)executable).executeOn(database, connection);
        }
    }
}

