/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.text.operation;

import java.sql.Connection;
import schemacrawler.schema.Database;
import schemacrawler.schemacrawler.SchemaCrawlerException;
import schemacrawler.tools.executable.BaseExecutable;
import schemacrawler.tools.options.OutputFormat;
import schemacrawler.tools.text.base.BaseFormatter;
import schemacrawler.tools.text.operation.DataJsonFormatter;
import schemacrawler.tools.text.operation.DataTextFormatter;
import schemacrawler.tools.text.operation.Operation;
import schemacrawler.tools.text.operation.OperationHandler;
import schemacrawler.tools.text.operation.OperationOptions;
import schemacrawler.tools.text.operation.Query;
import schemacrawler.tools.traversal.DataTraversalHandler;

public final class OperationExecutable
extends BaseExecutable {
    private OperationOptions operationOptions;

    public OperationExecutable(String command) {
        super(command);
    }

    public final OperationOptions getOperationOptions() {
        OperationOptions operationOptions = this.operationOptions == null ? new OperationOptions(this.additionalConfiguration) : this.operationOptions;
        return operationOptions;
    }

    public final void setOperationOptions(OperationOptions operationOptions) {
        this.operationOptions = operationOptions;
    }

    @Override
    protected void executeOn(Database database, Connection connection) throws Exception {
        DataTraversalHandler formatter = this.getDataTraversalHandler();
        Query query = this.getQuery();
        OperationHandler handler = new OperationHandler();
        handler.setDatabase(database);
        handler.setConnection(connection);
        handler.setFormatter(formatter);
        handler.setQuery(query);
        handler.traverse();
    }

    private DataTraversalHandler getDataTraversalHandler() throws SchemaCrawlerException {
        Operation operation = this.getOperation();
        OperationOptions operationOptions = this.getOperationOptions();
        OutputFormat outputFormat = this.outputOptions.getOutputFormat();
        BaseFormatter formatter = outputFormat == OutputFormat.json ? new DataJsonFormatter(operation, operationOptions, this.outputOptions) : new DataTextFormatter(operation, operationOptions, this.outputOptions);
        return formatter;
    }

    private Operation getOperation() {
        Operation operation = null;
        try {
            operation = Operation.valueOf(this.command);
        }
        catch (IllegalArgumentException e) {
            operation = null;
        }
        return operation;
    }

    private Query getQuery() {
        Query query;
        Operation operation = this.getOperation();
        if (operation == null) {
            String queryName = this.command;
            String queryString = this.additionalConfiguration != null ? (String)this.additionalConfiguration.get((Object)queryName) : null;
            query = new Query(queryName, queryString);
        } else {
            query = operation.getQuery();
        }
        return query;
    }
}

