/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.options;

import java.io.File;
import java.io.Writer;
import schemacrawler.schemacrawler.Options;
import schemacrawler.tools.options.OutputFormat;
import sf.util.ObjectToString;

public final class OutputOptions
implements Options {
    private static final long serialVersionUID = 7018337388923813055L;
    private String outputFormatValue;
    private File outputFile;
    private Writer writer;

    public OutputOptions() {
        this(OutputFormat.text.name());
    }

    public OutputOptions(String outputFormatValue) {
        this.outputFormatValue = outputFormatValue;
        this.outputFile = null;
        this.writer = null;
    }

    public OutputOptions(String outputFormatValue, File outputFile) {
        this.outputFormatValue = outputFormatValue;
        this.outputFile = outputFile;
        this.writer = null;
    }

    public OutputOptions(String outputFormatValue, Writer writer) {
        this.outputFormatValue = outputFormatValue;
        this.outputFile = null;
        this.writer = writer;
    }

    public File getOutputFile() {
        return this.outputFile;
    }

    public OutputFormat getOutputFormat() {
        OutputFormat outputFormat;
        try {
            outputFormat = OutputFormat.valueOf(this.outputFormatValue);
        }
        catch (IllegalArgumentException e) {
            outputFormat = null;
        }
        return outputFormat;
    }

    public String getOutputFormatValue() {
        return this.outputFormatValue;
    }

    public Writer getWriter() {
        return this.writer;
    }

    public boolean isConsoleOutput() {
        return this.outputFile == null && this.writer == null;
    }

    public boolean isFileOutput() {
        return this.outputFile != null && this.writer == null;
    }

    public void setOutputFile(File outputFile) {
        this.outputFile = outputFile;
    }

    public void setOutputFormatValue(String outputFormatValue) {
        if (outputFormatValue == null) {
            throw new IllegalArgumentException("Cannot use null value in a setter");
        }
        this.outputFormatValue = outputFormatValue;
    }

    public void setWriter(Writer writer) {
        this.writer = writer;
    }

    public String toString() {
        return ObjectToString.toString((Object)this);
    }
}

