/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import schemacrawler.crawl.MutableTable;
import schemacrawler.crawl.MutableView;
import schemacrawler.crawl.NamedObjectList;
import schemacrawler.schema.ForeignKey;
import schemacrawler.schema.ForeignKeyColumnReference;
import schemacrawler.schema.Table;
import schemacrawler.schema.View;
import sf.util.DirectedGraph;
import sf.util.GraphException;

final class TablesGraph
extends DirectedGraph<Table> {
    private static final Logger LOGGER = Logger.getLogger(TablesGraph.class.getName());

    TablesGraph(NamedObjectList<MutableTable> tables) {
        if (tables == null) {
            return;
        }
        for (MutableTable table : tables) {
            this.addVertex(table);
            for (ForeignKey foreignKey : table.getForeignKeys()) {
                for (ForeignKeyColumnReference columnReference : foreignKey.getColumnReferences()) {
                    this.addDirectedEdge((Comparable)columnReference.getPrimaryKeyColumn().getParent(), (Comparable)columnReference.getForeignKeyColumn().getParent());
                }
            }
        }
    }

    void setTablesSortIndices() {
        try {
            List sortedTables = this.topologicalSort();
            ArrayList<View> sortedViews = new ArrayList<View>();
            int sortIndex = 0;
            for (Table table : sortedTables) {
                if (table instanceof View) {
                    sortedViews.add((View)table);
                    continue;
                }
                if (!(table instanceof MutableTable)) continue;
                ((MutableTable)table).setSortIndex(sortIndex);
                ++sortIndex;
            }
            for (View view : sortedViews) {
                if (!(view instanceof MutableView)) continue;
                ((MutableView)view).setSortIndex(sortIndex);
                ++sortIndex;
            }
        }
        catch (GraphException e) {
            LOGGER.log(Level.CONFIG, e.getMessage());
        }
    }
}

