/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import schemacrawler.crawl.MutableTable;
import schemacrawler.crawl.NamedObjectList;
import schemacrawler.schema.Column;
import schemacrawler.schema.Table;
import schemacrawler.schema.TableRelationshipType;
import schemacrawler.schema.Trigger;
import schemacrawler.schema.View;
import schemacrawler.schemacrawler.InclusionRule;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;

class TableFilter {
    private static final Logger LOGGER = Logger.getLogger(TableFilter.class.getName());
    private final SchemaCrawlerOptions options;
    private final NamedObjectList<MutableTable> allTables;

    public TableFilter(SchemaCrawlerOptions options, NamedObjectList<MutableTable> allTables) {
        this.options = options;
        this.allTables = allTables;
    }

    public void filter() {
        Collection<MutableTable> filteredTables = this.doFilter();
        for (MutableTable table : this.allTables) {
            if (filteredTables.contains(table)) continue;
            this.allTables.remove(table);
        }
    }

    private Collection<MutableTable> doFilter() {
        HashSet<MutableTable> greppedTables = new HashSet<MutableTable>();
        for (MutableTable table : this.allTables) {
            if (!this.grepMatch(this.options, table)) continue;
            greppedTables.add(table);
        }
        int childTableFilterDepth = this.options.getChildTableFilterDepth();
        Collection<MutableTable> childTables = this.includeRelatedTables(TableRelationshipType.child, childTableFilterDepth, greppedTables);
        int parentTableFilterDepth = this.options.getParentTableFilterDepth();
        Collection<MutableTable> parentTables = this.includeRelatedTables(TableRelationshipType.parent, parentTableFilterDepth, greppedTables);
        HashSet<MutableTable> filteredTables = new HashSet<MutableTable>();
        filteredTables.addAll(greppedTables);
        filteredTables.addAll(childTables);
        filteredTables.addAll(parentTables);
        return filteredTables;
    }

    private boolean grepMatch(SchemaCrawlerOptions options, Table table) {
        boolean include;
        boolean invertMatch = options.isGrepInvertMatch();
        boolean checkIncludeForColumns = options.isGrepColumns();
        boolean checkIncludeForDefinitions = options.isGrepDefinitions();
        InclusionRule grepColumnInclusionRule = options.getGrepColumnInclusionRule();
        InclusionRule grepDefinitionInclusionRule = options.getGrepDefinitionInclusionRule();
        if (!checkIncludeForColumns && !checkIncludeForDefinitions) {
            return true;
        }
        boolean includeForColumns = false;
        boolean includeForDefinitions = false;
        for (Column column : table.getColumns()) {
            if (checkIncludeForColumns && grepColumnInclusionRule.include(column.getFullName())) {
                includeForColumns = true;
                break;
            }
            if (!checkIncludeForDefinitions || !grepDefinitionInclusionRule.include(column.getRemarks())) continue;
            includeForDefinitions = true;
            break;
        }
        if (checkIncludeForDefinitions) {
            if (grepDefinitionInclusionRule.include(table.getRemarks())) {
                includeForDefinitions = true;
            }
            if (table instanceof View && grepDefinitionInclusionRule.include(((View)table).getDefinition())) {
                includeForDefinitions = true;
            }
            for (Trigger trigger : table.getTriggers()) {
                if (!grepDefinitionInclusionRule.include(trigger.getActionStatement())) continue;
                includeForDefinitions = true;
                break;
            }
        }
        boolean bl = include = checkIncludeForColumns && includeForColumns || checkIncludeForDefinitions && includeForDefinitions;
        if (invertMatch) {
            boolean bl2 = include = !include;
        }
        if (!include) {
            LOGGER.log(Level.FINE, "Removing table " + table + " since it does not match the grep pattern");
        }
        return include;
    }

    private Collection<MutableTable> includeRelatedTables(TableRelationshipType tableRelationshipType, int depth, Set<MutableTable> greppedTables) {
        HashSet<MutableTable> includedTables = new HashSet<MutableTable>();
        includedTables.addAll(greppedTables);
        for (int i = 0; i < depth; ++i) {
            for (MutableTable table : new HashSet<MutableTable>(includedTables)) {
                for (Table relatedTable : table.getRelatedTables(tableRelationshipType)) {
                    includedTables.add((MutableTable)relatedTable);
                }
            }
        }
        return includedTables;
    }
}

