/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.util.Collection;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import schemacrawler.crawl.MutableRoutine;
import schemacrawler.crawl.NamedObjectList;
import schemacrawler.schema.Procedure;
import schemacrawler.schema.Routine;
import schemacrawler.schema.RoutineColumn;
import schemacrawler.schemacrawler.InclusionRule;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;

class RoutineFilter {
    private static final Logger LOGGER = Logger.getLogger(RoutineFilter.class.getName());
    private final SchemaCrawlerOptions options;
    private final NamedObjectList<MutableRoutine> allRoutines;

    public RoutineFilter(SchemaCrawlerOptions options, NamedObjectList<MutableRoutine> allRoutines) {
        this.options = options;
        this.allRoutines = allRoutines;
    }

    public void filter() {
        Collection<MutableRoutine> filteredRoutines = this.doFilter();
        for (MutableRoutine routine : this.allRoutines) {
            if (filteredRoutines.contains(routine)) continue;
            this.allRoutines.remove(routine);
        }
    }

    private Collection<MutableRoutine> doFilter() {
        HashSet<MutableRoutine> greppedRoutines = new HashSet<MutableRoutine>();
        for (MutableRoutine routine : this.allRoutines) {
            if (!this.grepMatch(this.options, routine)) continue;
            greppedRoutines.add(routine);
        }
        return greppedRoutines;
    }

    private boolean grepMatch(SchemaCrawlerOptions options, Routine routine) {
        boolean include;
        boolean invertMatch = options.isGrepInvertMatch();
        boolean checkIncludeForColumns = options.isGrepRoutineColumns();
        boolean checkIncludeForDefinitions = options.isGrepDefinitions();
        InclusionRule grepRoutineColumnInclusionRule = options.getGrepRoutineColumnInclusionRule();
        InclusionRule grepDefinitionInclusionRule = options.getGrepDefinitionInclusionRule();
        if (!checkIncludeForColumns && !checkIncludeForDefinitions) {
            return true;
        }
        boolean includeForColumns = false;
        boolean includeForDefinitions = false;
        for (RoutineColumn<? extends Routine> routineColumn : routine.getColumns()) {
            if (!checkIncludeForColumns || !grepRoutineColumnInclusionRule.include(routineColumn.getFullName())) continue;
            includeForColumns = true;
            break;
        }
        if (checkIncludeForDefinitions) {
            if (grepDefinitionInclusionRule.include(routine.getRemarks())) {
                includeForDefinitions = true;
            }
            if (routine instanceof Procedure && grepDefinitionInclusionRule.include(((Procedure)routine).getDefinition())) {
                includeForDefinitions = true;
            }
        }
        boolean bl = include = includeForColumns || includeForDefinitions;
        if (invertMatch) {
            boolean bl2 = include = !include;
        }
        if (!include) {
            LOGGER.log(Level.FINE, "Removing routine " + routine + " since it does not match the grep pattern");
        }
        return include;
    }
}

