/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import schemacrawler.crawl.AbstractDatabaseObject;
import schemacrawler.crawl.MutableCheckConstraint;
import schemacrawler.crawl.MutableColumn;
import schemacrawler.crawl.MutableForeignKey;
import schemacrawler.crawl.MutableIndex;
import schemacrawler.crawl.MutablePrimaryKey;
import schemacrawler.crawl.MutablePrivilege;
import schemacrawler.crawl.MutableTrigger;
import schemacrawler.crawl.NamedObjectList;
import schemacrawler.schema.CheckConstraint;
import schemacrawler.schema.Column;
import schemacrawler.schema.ForeignKey;
import schemacrawler.schema.ForeignKeyColumnReference;
import schemacrawler.schema.Index;
import schemacrawler.schema.IndexColumn;
import schemacrawler.schema.NamedObject;
import schemacrawler.schema.Privilege;
import schemacrawler.schema.Schema;
import schemacrawler.schema.Table;
import schemacrawler.schema.TableRelationshipType;
import schemacrawler.schema.TableType;
import schemacrawler.schema.Trigger;

class MutableTable
extends AbstractDatabaseObject
implements Table {
    private static final long serialVersionUID = 3257290248802284852L;
    private TableType tableType = TableType.unknown;
    private MutablePrimaryKey primaryKey;
    private final NamedObjectList<MutableColumn> columns = new NamedObjectList();
    private final NamedObjectList<MutableForeignKey> foreignKeys = new NamedObjectList();
    private final NamedObjectList<MutableIndex> indices = new NamedObjectList();
    private final NamedObjectList<MutableCheckConstraint> checkConstraints = new NamedObjectList();
    private final NamedObjectList<MutableTrigger> triggers = new NamedObjectList();
    private final NamedObjectList<MutablePrivilege<Table>> privileges = new NamedObjectList();
    private int sortIndex;

    MutableTable(Schema schema, String name) {
        super(schema, name);
    }

    @Override
    public int compareTo(NamedObject obj) {
        if (obj == null) {
            return -1;
        }
        int comparison = 0;
        if (comparison == 0 && obj instanceof MutableTable) {
            comparison = this.sortIndex - ((MutableTable)obj).sortIndex;
        }
        if (comparison == 0) {
            comparison = super.compareTo(obj);
        }
        return comparison;
    }

    @Override
    public Collection<CheckConstraint> getCheckConstraints() {
        return new ArrayList<CheckConstraint>(this.checkConstraints.values());
    }

    @Override
    public MutableColumn getColumn(String name) {
        return this.columns.lookup(this, name);
    }

    @Override
    public List<Column> getColumns() {
        return new ArrayList<Column>(this.columns.values());
    }

    @Override
    public String getColumnsListAsString() {
        List<Column> columnsArray = this.getColumns();
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < columnsArray.size(); ++i) {
            Column column = columnsArray.get(i);
            if (i > 0) {
                buffer.append(", ");
            }
            buffer.append(column.getName());
        }
        return buffer.toString();
    }

    @Override
    public Collection<ForeignKey> getExportedForeignKeys() {
        return this.getForeignKeys(TableAssociationType.exported);
    }

    @Override
    public MutableForeignKey getForeignKey(String name) {
        return this.foreignKeys.lookup(this, name);
    }

    @Override
    public Collection<ForeignKey> getForeignKeys() {
        return this.getForeignKeys(TableAssociationType.all);
    }

    @Override
    public Collection<ForeignKey> getImportedForeignKeys() {
        return this.getForeignKeys(TableAssociationType.imported);
    }

    @Override
    public MutableIndex getIndex(String name) {
        return this.indices.lookup(this, name);
    }

    @Override
    public Collection<Index> getIndices() {
        ArrayList<Index> values = new ArrayList<Index>(this.indices.values());
        return values;
    }

    @Override
    public MutablePrimaryKey getPrimaryKey() {
        return this.primaryKey;
    }

    public MutablePrivilege<Table> getPrivilege(String name) {
        return this.privileges.lookup(this, name);
    }

    @Override
    public Collection<Privilege<Table>> getPrivileges() {
        return new ArrayList<Privilege<Table>>(this.privileges.values());
    }

    @Override
    public Collection<Table> getRelatedTables(TableRelationshipType tableRelationshipType) {
        HashSet<Table> relatedTables = new HashSet<Table>();
        if (tableRelationshipType != null && tableRelationshipType != TableRelationshipType.none) {
            ArrayList<MutableForeignKey> foreignKeysList = new ArrayList<MutableForeignKey>(this.foreignKeys.values());
            for (MutableForeignKey mutableForeignKey : foreignKeysList) {
                for (ForeignKeyColumnReference columnReference : mutableForeignKey.getColumnReferences()) {
                    MutableTable parentTable = (MutableTable)columnReference.getPrimaryKeyColumn().getParent();
                    MutableTable childTable = (MutableTable)columnReference.getForeignKeyColumn().getParent();
                    switch (tableRelationshipType) {
                        case parent: {
                            if (!this.equals(childTable)) break;
                            relatedTables.add(parentTable);
                            break;
                        }
                        case child: {
                            if (!this.equals(parentTable)) break;
                            relatedTables.add(childTable);
                            break;
                        }
                    }
                }
            }
        }
        return relatedTables;
    }

    @Override
    public TableType getTableType() {
        return this.tableType;
    }

    @Override
    public MutableTrigger getTrigger(String name) {
        return this.lookupTrigger(name);
    }

    @Override
    public Collection<Trigger> getTriggers() {
        return new ArrayList<Trigger>(this.triggers.values());
    }

    @Override
    public final TableType getType() {
        return this.getTableType();
    }

    void addCheckConstraint(MutableCheckConstraint checkConstraint) {
        this.checkConstraints.add(checkConstraint);
    }

    void addColumn(MutableColumn column) {
        this.columns.add(column);
    }

    void addForeignKey(MutableForeignKey foreignKey) {
        this.foreignKeys.add(foreignKey);
    }

    void addIndex(MutableIndex index) {
        this.indices.add(index);
    }

    void addPrivilege(MutablePrivilege<Table> privilege) {
        this.privileges.add(privilege);
    }

    void addTrigger(MutableTrigger trigger) {
        this.triggers.add(trigger);
    }

    int getSortIndex() {
        return this.sortIndex;
    }

    MutableTrigger lookupTrigger(String triggerName) {
        return this.triggers.lookup(this, triggerName);
    }

    void replacePrimaryKey() {
        if (this.primaryKey == null) {
            return;
        }
        String primaryKeyName = this.primaryKey.getName();
        MutableIndex index = this.indices.lookup(this, primaryKeyName);
        if (index != null) {
            boolean indexHasPkColumns = false;
            List<IndexColumn> pkColumns = this.primaryKey.getColumns();
            List<IndexColumn> indexColumns = index.getColumns();
            if (pkColumns.size() == indexColumns.size()) {
                for (int i = 0; i < indexColumns.size() && pkColumns.get(i).equals(indexColumns.get(i)); ++i) {
                }
                indexHasPkColumns = true;
            }
            if (indexHasPkColumns) {
                this.indices.remove(index);
                this.setPrimaryKey(new MutablePrimaryKey(index));
            }
        }
    }

    void setPrimaryKey(MutablePrimaryKey primaryKey) {
        this.primaryKey = primaryKey;
    }

    void setSortIndex(int sortIndex) {
        this.sortIndex = sortIndex;
    }

    void setTableType(TableType tableType) {
        if (tableType == null) {
            throw new IllegalArgumentException("Null table type");
        }
        this.tableType = tableType;
    }

    private Collection<ForeignKey> getForeignKeys(TableAssociationType tableAssociationType) {
        ArrayList<ForeignKey> foreignKeysList = new ArrayList<ForeignKey>(this.foreignKeys.values());
        if (tableAssociationType != null && tableAssociationType != TableAssociationType.all) {
            Iterator iterator = foreignKeysList.iterator();
            while (iterator.hasNext()) {
                ForeignKey mutableForeignKey = (ForeignKey)iterator.next();
                boolean isExportedKey = false;
                boolean isImportedKey = false;
                for (ForeignKeyColumnReference columnReference : mutableForeignKey.getColumnReferences()) {
                    if (((Table)columnReference.getPrimaryKeyColumn().getParent()).equals(this)) {
                        isExportedKey = true;
                    }
                    if (!((Table)columnReference.getForeignKeyColumn().getParent()).equals(this)) continue;
                    isImportedKey = true;
                }
                switch (tableAssociationType) {
                    case exported: {
                        if (isExportedKey) break;
                        iterator.remove();
                        break;
                    }
                    case imported: {
                        if (isImportedKey) break;
                        iterator.remove();
                        break;
                    }
                }
            }
        }
        return foreignKeysList;
    }

    private static enum TableAssociationType {
        all,
        exported,
        imported;

    }
}

