/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.io.Serializable;
import java.sql.DriverPropertyInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import schemacrawler.crawl.MutableProperty;
import schemacrawler.schema.JdbcDriverProperty;
import schemacrawler.schema.Property;

final class MutableJdbcDriverProperty
extends MutableProperty
implements JdbcDriverProperty {
    private static final long serialVersionUID = 8030156654422512161L;
    private final String description;
    private final boolean required;
    private final List<String> choices;

    MutableJdbcDriverProperty(DriverPropertyInfo driverPropertyInfo) {
        super(driverPropertyInfo.name, (Serializable)((Object)driverPropertyInfo.value));
        this.description = driverPropertyInfo.description;
        this.required = driverPropertyInfo.required;
        if (driverPropertyInfo.choices == null) {
            this.choices = Collections.emptyList();
        } else {
            this.choices = Arrays.asList(driverPropertyInfo.choices);
            Collections.sort(this.choices);
        }
    }

    @Override
    public int compareTo(Property otherProperty) {
        if (otherProperty == null) {
            return -1;
        }
        return this.getName().toLowerCase().compareTo(otherProperty.getName().toLowerCase());
    }

    @Override
    public Collection<String> getChoices() {
        return new ArrayList<String>(this.choices);
    }

    @Override
    public String getDescription() {
        if (this.description != null) {
            return this.description;
        }
        return "";
    }

    @Override
    public String getValue() {
        return (String)((Object)super.getValue());
    }

    @Override
    public boolean isRequired() {
        return this.required;
    }
}

