/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import schemacrawler.crawl.AbstractDatabaseObject;
import schemacrawler.crawl.JavaSqlType;
import schemacrawler.crawl.JavaSqlTypesUtility;
import schemacrawler.schema.ColumnDataType;
import schemacrawler.schema.Schema;
import schemacrawler.schema.SearchableType;
import sf.util.Utility;

final class MutableColumnDataType
extends AbstractDatabaseObject
implements ColumnDataType {
    private static final long serialVersionUID = 3688503281676530744L;
    private int javaSqlType;
    private String javaSqlTypeName;
    private String javaSqlTypeMappedClassName;
    private boolean userDefined;
    private long precision;
    private String literalPrefix;
    private String literalSuffix;
    private String createParameters;
    private boolean nullable;
    private boolean caseSensitive;
    private SearchableType searchable = SearchableType.unknown;
    private boolean unsigned;
    private boolean fixedPrecisionScale;
    private boolean autoIncrementable;
    private String localizedTypeName;
    private int minimumScale;
    private int maximumScale;
    private int numPrecisionRadix;
    private ColumnDataType baseType;

    MutableColumnDataType(Schema schema, String name) {
        super(schema, name);
        this.setTypeFromJavaSqlType(JavaSqlType.UNKNOWN);
        this.createParameters = "";
    }

    @Override
    public ColumnDataType getBaseType() {
        return this.baseType;
    }

    @Override
    public String getCreateParameters() {
        return this.createParameters;
    }

    @Override
    public String getDatabaseSpecificTypeName() {
        return this.getName();
    }

    @Override
    public String getLiteralPrefix() {
        return this.literalPrefix;
    }

    @Override
    public String getLiteralSuffix() {
        return this.literalSuffix;
    }

    @Override
    public String getLocalTypeName() {
        return this.localizedTypeName;
    }

    @Override
    public int getMaximumScale() {
        return this.maximumScale;
    }

    @Override
    public int getMinimumScale() {
        return this.minimumScale;
    }

    @Override
    public int getNumPrecisionRadix() {
        return this.numPrecisionRadix;
    }

    @Override
    public long getPrecision() {
        return this.precision;
    }

    @Override
    public SearchableType getSearchable() {
        return this.searchable;
    }

    @Override
    public int getType() {
        return this.javaSqlType;
    }

    @Override
    public String getTypeClassName() {
        return this.javaSqlTypeMappedClassName;
    }

    @Override
    public String getTypeName() {
        return this.javaSqlTypeName;
    }

    @Override
    public boolean isAutoIncrementable() {
        return this.autoIncrementable;
    }

    @Override
    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    @Override
    public boolean isFixedPrecisionScale() {
        return this.fixedPrecisionScale;
    }

    @Override
    public boolean isNullable() {
        return this.nullable;
    }

    @Override
    public boolean isUnsigned() {
        return this.unsigned;
    }

    @Override
    public boolean isUserDefined() {
        return this.userDefined;
    }

    void setAutoIncrementable(boolean autoIncrementable) {
        this.autoIncrementable = autoIncrementable;
    }

    void setBaseType(ColumnDataType baseType) {
        this.baseType = baseType;
    }

    void setCaseSensitive(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    void setCreateParameters(String createParams) {
        this.createParameters = createParams;
    }

    void setFixedPrecisionScale(boolean fixedPrecisionScale) {
        this.fixedPrecisionScale = fixedPrecisionScale;
    }

    void setLiteralPrefix(String literalPrefix) {
        this.literalPrefix = literalPrefix;
    }

    void setLiteralSuffix(String literalSuffix) {
        this.literalSuffix = literalSuffix;
    }

    void setLocalTypeName(String localTypeName) {
        this.localizedTypeName = localTypeName;
    }

    void setMaximumScale(int maximumScale) {
        this.maximumScale = maximumScale;
    }

    void setMinimumScale(int minimumScale) {
        this.minimumScale = minimumScale;
    }

    void setNullable(boolean nullable) {
        this.nullable = nullable;
    }

    void setNumPrecisionRadix(int numPrecisionRadix) {
        this.numPrecisionRadix = numPrecisionRadix;
    }

    void setPrecision(long precision) {
        this.precision = precision;
    }

    void setSearchable(SearchableType searchable) {
        this.searchable = searchable;
    }

    void setType(int type, String typeClassName) {
        this.setTypeFromJavaSqlType(JavaSqlTypesUtility.lookupSqlDataType(type));
        if (this.javaSqlTypeMappedClassName == null && !Utility.isBlank(typeClassName)) {
            this.javaSqlTypeMappedClassName = typeClassName;
        }
    }

    void setUnsigned(boolean unsignedAttribute) {
        this.unsigned = unsignedAttribute;
    }

    void setUserDefined(boolean userDefined) {
        this.userDefined = userDefined;
    }

    private void setTypeFromJavaSqlType(JavaSqlType javaSqlType) {
        if (javaSqlType != null) {
            this.javaSqlType = javaSqlType.getJavaSqlType();
            this.javaSqlTypeName = javaSqlType.getJavaSqlTypeName();
            this.javaSqlTypeMappedClassName = javaSqlType.getJavaSqlTypeMappedClassName();
        }
    }
}

