/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import schemacrawler.schema.NamedObject;
import schemacrawler.utility.NamedObjectSort;
import sf.util.Utility;

abstract class AbstractNamedObject
implements NamedObject {
    private static final long serialVersionUID = -1486322887991472729L;
    private final String name;
    private String remarks;
    private final Map<String, Object> attributeMap = new HashMap<String, Object>();

    AbstractNamedObject(String name) {
        this.name = name;
    }

    @Override
    public int compareTo(NamedObject obj) {
        if (obj == null) {
            return -1;
        }
        return NamedObjectSort.alphabetical.compare(this, obj);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AbstractNamedObject)) {
            return false;
        }
        AbstractNamedObject other = (AbstractNamedObject)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    @Override
    public final Object getAttribute(String name) {
        return this.attributeMap.get(name);
    }

    @Override
    public final <T> T getAttribute(String name, T defaultValue) {
        Object attributeValue = this.getAttribute(name);
        if (attributeValue == null) {
            return defaultValue;
        }
        try {
            return (T)attributeValue;
        }
        catch (ClassCastException e) {
            return defaultValue;
        }
    }

    @Override
    public final Map<String, Object> getAttributes() {
        return Collections.unmodifiableMap(this.attributeMap);
    }

    @Override
    public String getFullName() {
        return this.name;
    }

    @Override
    public String getLookupKey() {
        return this.getFullName();
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public final String getRemarks() {
        return this.remarks;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    @Override
    public final void setAttribute(String name, Object value) {
        if (!Utility.isBlank(name)) {
            if (value == null) {
                this.attributeMap.remove(name);
            } else {
                this.attributeMap.put(name, value);
            }
        }
    }

    public String toString() {
        return this.name;
    }

    final void addAttributes(Map<String, Object> values) {
        if (values != null) {
            this.attributeMap.putAll(values);
        }
    }

    final void setRemarks(String remarks) {
        this.remarks = remarks == null ? "" : remarks;
    }
}

