/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.schemacrawler;

import schemacrawler.schemacrawler.Config;
import schemacrawler.schemacrawler.Options;

public abstract class BaseConfigOptions
implements Options {
    private static final long serialVersionUID = -8133661515343358712L;
    private final String prefix;
    private final Config config = new Config();

    protected BaseConfigOptions(String prefix) {
        this.prefix = prefix;
    }

    public Config toConfig() {
        return new Config(this.config);
    }

    public String toString() {
        return this.config.toString();
    }

    protected boolean getBooleanValue(Config config, String propertyName) {
        return this.getBooleanValue(config, propertyName, false);
    }

    protected boolean getBooleanValue(Config config, String propertyName, boolean defaultValue) {
        if (config == null) {
            return defaultValue;
        }
        return config.getBooleanValue(this.prefix + propertyName);
    }

    protected boolean getBooleanValue(String propertyName) {
        return this.getBooleanValue(propertyName, false);
    }

    protected boolean getBooleanValue(String propertyName, boolean defaultValue) {
        return this.getBooleanValue(this.config, propertyName, defaultValue);
    }

    protected int getIntegerValue(Config config, String propertyName, int defaultValue) {
        if (config == null) {
            return defaultValue;
        }
        return config.getIntegerValue(this.prefix + propertyName, defaultValue);
    }

    protected int getIntegerValue(String propertyName, int defaultValue) {
        return this.getIntegerValue(this.config, this.prefix + propertyName, defaultValue);
    }

    protected String getStringValue(Config config, String propertyName, String defaultValue) {
        if (config == null) {
            return defaultValue;
        }
        return config.getStringValue(this.prefix + propertyName, defaultValue);
    }

    protected String getStringValue(String propertyName, String defaultValue) {
        return this.getStringValue(this.config, this.prefix + propertyName, defaultValue);
    }

    protected void setBooleanValue(String propertyName, boolean value) {
        this.config.put(this.prefix + propertyName, Boolean.toString(value));
    }

    protected void setIntegerValue(String propertyName, int value) {
        this.config.put(this.prefix + propertyName, Integer.toString(value));
    }

    protected void setStringValue(String propertyName, String value) {
        this.config.put(this.prefix + propertyName, value);
    }
}

