/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import schemacrawler.crawl.AbstractDatabaseObject;
import schemacrawler.crawl.AbstractRetriever;
import schemacrawler.crawl.ColumnReference;
import schemacrawler.crawl.MetadataResultSet;
import schemacrawler.crawl.MutableColumn;
import schemacrawler.crawl.MutableDatabase;
import schemacrawler.crawl.MutableForeignKey;
import schemacrawler.crawl.MutableIndex;
import schemacrawler.crawl.MutableIndexColumn;
import schemacrawler.crawl.MutablePrimaryKey;
import schemacrawler.crawl.MutableTable;
import schemacrawler.crawl.MutableView;
import schemacrawler.crawl.NamedObjectList;
import schemacrawler.crawl.RetrieverConnection;
import schemacrawler.crawl.TableReference;
import schemacrawler.schema.Column;
import schemacrawler.schema.ForeignKeyDeferrability;
import schemacrawler.schema.ForeignKeyUpdateRule;
import schemacrawler.schema.IndexColumnSortSequence;
import schemacrawler.schema.IndexType;
import schemacrawler.schema.SchemaReference;
import schemacrawler.schema.Table;
import schemacrawler.schema.TableType;
import schemacrawler.schemacrawler.InclusionRule;
import schemacrawler.schemacrawler.SchemaCrawlerSQLException;
import sf.util.Utility;

final class TableRetriever
extends AbstractRetriever {
    private static final Logger LOGGER = Logger.getLogger(TableRetriever.class.getName());

    private static String[] toStrings(Collection<TableType> tableTypes) {
        if (tableTypes == null || tableTypes.isEmpty()) {
            return new String[0];
        }
        ArrayList<String> tableTypeStrings = new ArrayList<String>(tableTypes.size());
        for (TableType tableType : tableTypes) {
            if (tableType == null) continue;
            tableTypeStrings.add(tableType.toString().toUpperCase(Locale.ENGLISH));
        }
        return tableTypeStrings.toArray(new String[tableTypeStrings.size()]);
    }

    TableRetriever(RetrieverConnection retrieverConnection, MutableDatabase database) throws SQLException {
        super(retrieverConnection, database);
    }

    void retrieveColumns(MutableTable table, InclusionRule columnInclusionRule) throws SQLException {
        MetadataResultSet results = null;
        try {
            results = new MetadataResultSet(this.getMetaData().getColumns(this.unquotedName(table.getSchema().getCatalogName()), this.unquotedName(table.getSchema().getName()), this.unquotedName(table.getName()), null));
            while (results.next()) {
                String defaultValue = results.getString("COLUMN_DEF");
                String columnCatalogName = this.quotedName(results.getString("TABLE_CAT"));
                String schemaName = this.quotedName(results.getString("TABLE_SCHEM"));
                String tableName = this.quotedName(results.getString("TABLE_NAME"));
                String columnName = this.quotedName(results.getString("COLUMN_NAME"));
                LOGGER.log(Level.FINER, String.format("Retrieving column: %s.%s", tableName, columnName));
                MutableColumn column = this.lookupOrCreateColumn(table, columnName, false);
                String columnFullName = column.getFullName();
                if (!columnInclusionRule.include(columnFullName) || !table.getName().equals(tableName) || !this.belongsToSchema(table, columnCatalogName, schemaName)) continue;
                column = this.lookupOrCreateColumn(table, columnName, true);
                int ordinalPosition = results.getInt("ORDINAL_POSITION", 0);
                int dataType = results.getInt("DATA_TYPE", 0);
                String typeName = results.getString("TYPE_NAME");
                int size = results.getInt("COLUMN_SIZE", 0);
                int decimalDigits = results.getInt("DECIMAL_DIGITS", 0);
                boolean isNullable = results.getInt("NULLABLE", 2) == 1;
                String remarks = results.getString("REMARKS");
                column.setOrdinalPosition(ordinalPosition);
                column.setColumnDataType(this.lookupOrCreateColumnDataType(table.getSchema(), dataType, typeName));
                column.setSize(size);
                column.setDecimalDigits(decimalDigits);
                column.setRemarks(remarks);
                column.setNullable(isNullable);
                if (defaultValue != null) {
                    column.setDefaultValue(defaultValue);
                }
                column.addAttributes(results.getAttributes());
                table.addColumn(column);
            }
        }
        catch (SQLException e) {
            throw new SchemaCrawlerSQLException("Could not retrieve columns for table " + table, e);
        }
        finally {
            if (results != null) {
                results.close();
            }
        }
    }

    void retrieveForeignKeys(MutableTable table) throws SQLException {
        NamedObjectList<MutableForeignKey> foreignKeys = new NamedObjectList<MutableForeignKey>();
        DatabaseMetaData metaData = this.getMetaData();
        try {
            MetadataResultSet results = new MetadataResultSet(metaData.getImportedKeys(this.unquotedName(table.getSchema().getCatalogName()), this.unquotedName(table.getSchema().getName()), this.unquotedName(table.getName())));
            this.createForeignKeys(results, foreignKeys);
            results = new MetadataResultSet(metaData.getExportedKeys(this.unquotedName(table.getSchema().getCatalogName()), this.unquotedName(table.getSchema().getName()), this.unquotedName(table.getName())));
            this.createForeignKeys(results, foreignKeys);
        }
        catch (SQLException e) {
            throw new SchemaCrawlerSQLException("Could not retrieve forign keys for table " + table, e);
        }
    }

    void retrieveIndices(MutableTable table, boolean unique) throws SQLException {
        SQLException sqlEx = null;
        try {
            this.retrieveIndices1(table, unique);
        }
        catch (SQLException e) {
            sqlEx = e;
        }
        if (sqlEx != null) {
            try {
                sqlEx = null;
                this.retrieveIndices2(table, unique);
            }
            catch (SQLException e) {
                sqlEx = e;
            }
        }
        if (sqlEx != null) {
            throw sqlEx;
        }
    }

    void retrievePrimaryKey(MutableTable table) throws SQLException {
        MetadataResultSet results = null;
        try {
            results = new MetadataResultSet(this.getMetaData().getPrimaryKeys(this.unquotedName(table.getSchema().getCatalogName()), this.unquotedName(table.getSchema().getName()), this.unquotedName(table.getName())));
            while (results.next()) {
                MutableColumn column;
                String columnName = this.quotedName(results.getString("COLUMN_NAME"));
                String primaryKeyName = this.quotedName(results.getString("PK_NAME"));
                int keySequence = Integer.parseInt(results.getString("KEY_SEQ"));
                MutablePrimaryKey primaryKey = table.getPrimaryKey();
                if (primaryKey == null) {
                    primaryKey = new MutablePrimaryKey(table, primaryKeyName);
                }
                if ((column = table.getColumn(columnName)) != null) {
                    column.setPartOfPrimaryKey(true);
                    MutableIndexColumn indexColumn = new MutableIndexColumn(primaryKey, column);
                    indexColumn.setSortSequence(IndexColumnSortSequence.ascending);
                    indexColumn.setIndexOrdinalPosition(keySequence);
                    primaryKey.addColumn(indexColumn);
                }
                table.setPrimaryKey(primaryKey);
            }
        }
        catch (SQLException e) {
            throw new SchemaCrawlerSQLException("Could not retrieve primary keys for table " + table, e);
        }
        finally {
            if (results != null) {
                results.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void retrieveTables(String catalogName, String schemaName, String tableNamePattern, Collection<TableType> tableTypes, InclusionRule tableInclusionRule) throws SQLException {
        if (tableInclusionRule == null || tableInclusionRule.equals(InclusionRule.EXCLUDE_ALL)) {
            return;
        }
        MetadataResultSet results = null;
        try {
            results = new MetadataResultSet(this.getMetaData().getTables(this.unquotedName(catalogName), this.unquotedName(schemaName), tableNamePattern, TableRetriever.toStrings(tableTypes)));
            while (results.next()) {
                String tableName = this.quotedName(results.getString("TABLE_NAME"));
                LOGGER.log(Level.FINER, String.format("Retrieving table: %s.%s", schemaName, tableName));
                TableType tableType = results.getEnum("TABLE_TYPE", TableType.unknown);
                String remarks = results.getString("REMARKS");
                SchemaReference schema = new SchemaReference(catalogName, schemaName);
                MutableTable table = tableType == TableType.view ? new MutableView(schema, tableName) : new MutableTable(schema, tableName);
                if (!tableInclusionRule.include(table.getFullName())) continue;
                table.setTableType(tableType);
                table.setRemarks(remarks);
                this.database.addTable(table);
            }
        }
        finally {
            if (results != null) {
                results.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createForeignKeys(MetadataResultSet results, NamedObjectList<MutableForeignKey> foreignKeys) throws SQLException {
        try {
            while (results.next()) {
                MutableForeignKey foreignKey;
                String foreignKeyName = this.quotedName(results.getString("FK_NAME"));
                LOGGER.log(Level.FINER, "Retrieving foreign key: " + foreignKeyName);
                String pkTableCatalogName = this.quotedName(results.getString("PKTABLE_CAT"));
                String pkTableSchemaName = this.quotedName(results.getString("PKTABLE_SCHEM"));
                String pkTableName = this.quotedName(results.getString("PKTABLE_NAME"));
                String pkColumnName = this.quotedName(results.getString("PKCOLUMN_NAME"));
                String fkTableCatalogName = this.quotedName(results.getString("FKTABLE_CAT"));
                String fkTableSchemaName = this.quotedName(results.getString("FKTABLE_SCHEM"));
                String fkTableName = this.quotedName(results.getString("FKTABLE_NAME"));
                String fkColumnName = this.quotedName(results.getString("FKCOLUMN_NAME"));
                int keySequence = results.getInt("KEY_SEQ", 0);
                int updateRule = results.getInt("UPDATE_RULE", ForeignKeyUpdateRule.unknown.getId());
                int deleteRule = results.getInt("DELETE_RULE", ForeignKeyUpdateRule.unknown.getId());
                int deferrability = results.getInt("DEFERRABILITY", ForeignKeyDeferrability.unknown.getId());
                Column pkColumn = this.lookupOrCreateColumn(pkTableCatalogName, pkTableSchemaName, pkTableName, pkColumnName);
                Column fkColumn = this.lookupOrCreateColumn(fkTableCatalogName, fkTableSchemaName, fkTableName, fkColumnName);
                if (pkColumn == null || fkColumn == null) continue;
                if (Utility.isBlank(foreignKeyName)) {
                    foreignKeyName = String.format("SC_%s_%s", Integer.toHexString(pkColumn.getFullName().hashCode()).toUpperCase(), Integer.toHexString(fkColumn.getFullName().hashCode()).toUpperCase());
                }
                if ((foreignKey = foreignKeys.lookup(foreignKeyName)) == null) {
                    foreignKey = new MutableForeignKey(foreignKeyName);
                    foreignKeys.add(foreignKey);
                }
                foreignKey.addColumnReference(keySequence, pkColumn, fkColumn);
                foreignKey.setUpdateRule(ForeignKeyUpdateRule.valueOf(updateRule));
                foreignKey.setDeleteRule(ForeignKeyUpdateRule.valueOf(deleteRule));
                foreignKey.setDeferrability(ForeignKeyDeferrability.valueOf(deferrability));
                foreignKey.addAttributes(results.getAttributes());
                if (fkColumn instanceof MutableColumn) {
                    ((MutableColumn)fkColumn).setReferencedColumn(pkColumn);
                    ((MutableTable)fkColumn.getParent()).addForeignKey(foreignKey);
                } else if (fkColumn instanceof ColumnReference) {
                    ((ColumnReference)fkColumn).setReferencedColumn(pkColumn);
                    ((TableReference)fkColumn.getParent()).addForeignKey(foreignKey);
                }
                if (pkColumn instanceof MutableColumn) {
                    ((MutableTable)pkColumn.getParent()).addForeignKey(foreignKey);
                    continue;
                }
                if (!(pkColumn instanceof ColumnReference)) continue;
                ((TableReference)pkColumn.getParent()).addForeignKey(foreignKey);
            }
        }
        finally {
            results.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createIndices(MutableTable table, MetadataResultSet results) throws SQLException {
        try {
            while (results.next()) {
                MutableIndex index;
                String indexName = this.quotedName(results.getString("INDEX_NAME"));
                LOGGER.log(Level.FINER, String.format("Retrieving index: %s.%s", table.getFullName(), indexName));
                String columnName = this.quotedName(results.getString("COLUMN_NAME"));
                if (Utility.isBlank(columnName)) continue;
                boolean uniqueIndex = !results.getBoolean("NON_UNIQUE");
                int type = results.getInt("TYPE", IndexType.unknown.getId());
                int ordinalPosition = results.getInt("ORDINAL_POSITION", 0);
                IndexColumnSortSequence sortSequence = IndexColumnSortSequence.valueOfFromCode(results.getString("ASC_OR_DESC"));
                int cardinality = results.getInt("CARDINALITY", 0);
                int pages = results.getInt("PAGES", 0);
                MutableColumn column = table.getColumn(columnName);
                if (column == null) continue;
                if (Utility.isBlank(indexName)) {
                    indexName = String.format("SC_%s", Integer.toHexString(column.getFullName().hashCode()).toUpperCase());
                }
                if ((index = table.getIndex(indexName)) == null) {
                    index = new MutableIndex(table, indexName);
                    table.addIndex(index);
                }
                column.setPartOfUniqueIndex(uniqueIndex);
                MutableIndexColumn indexColumn = new MutableIndexColumn(index, column);
                indexColumn.setIndexOrdinalPosition(ordinalPosition);
                indexColumn.setSortSequence(sortSequence);
                index.addColumn(indexColumn);
                index.setUnique(uniqueIndex);
                index.setIndexType(IndexType.valueOf(type));
                index.setCardinality(cardinality);
                index.setPages(pages);
                index.addAttributes(results.getAttributes());
            }
        }
        finally {
            results.close();
        }
    }

    private MutableColumn lookupOrCreateColumn(MutableTable table, String columnName, boolean add) {
        MutableColumn column = null;
        if (table != null) {
            column = table.getColumn(columnName);
        }
        if (column == null) {
            column = new MutableColumn(table, columnName);
            if (add) {
                LOGGER.log(Level.FINER, String.format("Adding column to table: %s", column.getFullName()));
                table.addColumn(column);
            }
        }
        return column;
    }

    private Column lookupOrCreateColumn(String catalogName, String schemaName, String tableName, String columnName) {
        boolean supportsCatalogs = this.getRetrieverConnection().isSupportsCatalogs();
        Column column = null;
        SchemaReference schema = new SchemaReference(supportsCatalogs ? catalogName : null, schemaName);
        if (schema != null) {
            AbstractDatabaseObject table = this.database.getTable(new SchemaReference(catalogName, schemaName), tableName);
            if (table != null) {
                column = table.getColumn(columnName);
            }
            if (column == null) {
                table = new TableReference(schema, tableName);
                column = new ColumnReference((Table)((Object)table), columnName);
                ((TableReference)table).addColumn(column);
                LOGGER.log(Level.FINER, String.format("Creating column reference for a column that is referenced by a foreign key: %s", column.getFullName()));
            }
        }
        return column;
    }

    private void retrieveIndices1(MutableTable table, boolean unique) throws SQLException {
        MetadataResultSet results = null;
        try {
            results = new MetadataResultSet(this.getMetaData().getIndexInfo(this.unquotedName(table.getSchema().getCatalogName()), this.unquotedName(table.getSchema().getName()), this.unquotedName(table.getName()), unique, true));
            this.createIndices(table, results);
        }
        catch (SQLException e) {
            throw new SchemaCrawlerSQLException("Could not retrieve indices for table " + table, e);
        }
        finally {
            if (results != null) {
                results.close();
            }
        }
    }

    private void retrieveIndices2(MutableTable table, boolean unique) throws SQLException {
        MetadataResultSet results = null;
        try {
            results = new MetadataResultSet(this.getMetaData().getIndexInfo(null, null, table.getName(), unique, true));
            this.createIndices(table, results);
        }
        catch (SQLException e) {
            throw new SchemaCrawlerSQLException("Could not retrieve indices for table " + table, e);
        }
        finally {
            if (results != null) {
                results.close();
            }
        }
    }
}

