/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.text.utility;

import schemacrawler.tools.options.OutputFormat;
import schemacrawler.tools.text.utility.TableCell;
import schemacrawler.tools.text.utility.TableRow;
import schemacrawler.tools.text.utility.TextFormattingHelper;
import sf.util.Utility;

abstract class BaseTextFormattingHelper
implements TextFormattingHelper {
    static final String DASHED_SEPARATOR = BaseTextFormattingHelper.separator("-");
    private final OutputFormat outputFormat;

    static String separator(String pattern) {
        StringBuilder dashedSeparator = new StringBuilder();
        for (int i = 0; i < 72 / pattern.length(); ++i) {
            dashedSeparator.append(pattern);
        }
        return dashedSeparator.toString();
    }

    BaseTextFormattingHelper(OutputFormat outputFormat) {
        this.outputFormat = outputFormat;
    }

    @Override
    public String createDefinitionRow(String definition) {
        TableRow row = new TableRow(this.outputFormat);
        row.add(new TableCell(definition, 0, TableCell.Align.left, 3, "definition", this.outputFormat));
        return row.toString();
    }

    @Override
    public String createDescriptionRow(String description) {
        TableRow row = new TableRow(this.outputFormat);
        row.add(new TableCell("", "ordinal", this.outputFormat));
        row.add(new TableCell(description, 0, TableCell.Align.left, 2, "definition", this.outputFormat));
        return row.toString();
    }

    @Override
    public String createDetailRow(String ordinal, String subName, String type) {
        int subNameWidth = 32;
        int typeWidth = 28;
        TableRow row = new TableRow(this.outputFormat);
        if (Utility.isBlank((String)ordinal)) {
            row.add(new TableCell("", "ordinal", this.outputFormat));
        } else {
            row.add(new TableCell(ordinal, 2, TableCell.Align.left, 1, "ordinal", this.outputFormat));
        }
        row.add(new TableCell(subName, 32, TableCell.Align.left, 1, "subname", this.outputFormat));
        row.add(new TableCell(type, 28, TableCell.Align.left, 1, "type", this.outputFormat));
        return row.toString();
    }

    @Override
    public String createEmptyRow() {
        return new TableRow(this.outputFormat, 4).toString();
    }

    @Override
    public String createNameRow(String name, String description, boolean underscore) {
        int nameWidth = 34;
        int descriptionWidth = 36;
        if (name.length() > nameWidth && description.length() < descriptionWidth) {
            descriptionWidth = Math.max(description.length(), descriptionWidth - (name.length() - nameWidth));
        }
        if (description.length() > descriptionWidth && name.length() < nameWidth) {
            nameWidth = Math.max(name.length(), nameWidth - (description.length() - descriptionWidth));
        }
        TableRow row = new TableRow(this.outputFormat);
        row.add(new TableCell(name, nameWidth, TableCell.Align.left, 2, "name" + (underscore ? " underscore" : ""), this.outputFormat));
        row.add(new TableCell(description, descriptionWidth, TableCell.Align.right, 1, "description" + (underscore ? " underscore" : ""), this.outputFormat));
        String nameRowString = row.toString();
        if (underscore && this.outputFormat != OutputFormat.html) {
            nameRowString = nameRowString + Utility.NEWLINE + DASHED_SEPARATOR;
        }
        return nameRowString;
    }

    @Override
    public String createNameValueRow(String name, String value) {
        int nameWidth = 36;
        TableRow row = new TableRow(this.outputFormat);
        row.add(new TableCell(name, 36, TableCell.Align.left, 1, "", this.outputFormat));
        row.add(new TableCell(value, "", this.outputFormat));
        return row.toString();
    }

    @Override
    public String createRow(String[] columnData) {
        OutputFormat outputFormat = this.outputFormat;
        if (outputFormat == OutputFormat.text) {
            outputFormat = OutputFormat.tsv;
        }
        TableRow row = new TableRow(outputFormat);
        for (String element : columnData) {
            row.add(new TableCell(element, "", outputFormat));
        }
        return row.toString();
    }

    @Override
    public String createRowHeader(String[] columnNames) {
        OutputFormat outputFormat = this.outputFormat;
        if (outputFormat == OutputFormat.text) {
            outputFormat = OutputFormat.tsv;
        }
        TableRow row = new TableRow(outputFormat);
        for (String columnName : columnNames) {
            row.add(new TableCell(columnName, "name", outputFormat));
        }
        return row.toString();
    }
}

