/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.text.schema;

import java.util.Locale;
import schemacrawler.schema.ActionOrientationType;
import schemacrawler.schema.CheckConstraint;
import schemacrawler.schema.Column;
import schemacrawler.schema.ColumnDataType;
import schemacrawler.schema.ColumnMap;
import schemacrawler.schema.ConditionTimingType;
import schemacrawler.schema.EventManipulationType;
import schemacrawler.schema.ForeignKey;
import schemacrawler.schema.ForeignKeyColumnMap;
import schemacrawler.schema.ForeignKeyUpdateRule;
import schemacrawler.schema.Index;
import schemacrawler.schema.IndexColumn;
import schemacrawler.schema.IndexType;
import schemacrawler.schema.Privilege;
import schemacrawler.schema.Procedure;
import schemacrawler.schema.ProcedureColumn;
import schemacrawler.schema.Table;
import schemacrawler.schema.Trigger;
import schemacrawler.schema.View;
import schemacrawler.schemacrawler.SchemaCrawlerException;
import schemacrawler.tools.analysis.AnalyzedDatabase;
import schemacrawler.tools.analysis.Lint;
import schemacrawler.tools.options.OutputOptions;
import schemacrawler.tools.text.base.BaseTabularFormatter;
import schemacrawler.tools.text.schema.SchemaFormatter;
import schemacrawler.tools.text.schema.SchemaTextDetailType;
import schemacrawler.tools.text.schema.SchemaTextOptions;
import schemacrawler.tools.text.utility.TextFormattingHelper;
import sf.util.Utility;

final class SchemaTextFormatter
extends BaseTabularFormatter<SchemaTextOptions>
implements SchemaFormatter {
    private final boolean isVerbose;
    private final boolean isNotList;
    private final boolean isList;

    private static String negate(boolean positive, String text) {
        String textValue = text;
        if (!positive) {
            textValue = "not " + textValue;
        }
        return textValue;
    }

    SchemaTextFormatter(SchemaTextDetailType schemaTextDetailType, SchemaTextOptions options, OutputOptions outputOptions) throws SchemaCrawlerException {
        super(options, schemaTextDetailType == SchemaTextDetailType.details, outputOptions);
        this.isVerbose = schemaTextDetailType.isGreaterThanOrEqualTo(SchemaTextDetailType.details);
        this.isNotList = schemaTextDetailType != SchemaTextDetailType.list;
        this.isList = schemaTextDetailType == SchemaTextDetailType.list;
    }

    private void printCheckConstraints(CheckConstraint[] constraints) {
        for (CheckConstraint constraint : constraints) {
            if (constraint == null) continue;
            String constraintName = "";
            if (!((SchemaTextOptions)this.options).isHideConstraintNames()) {
                constraintName = constraint.getName();
            }
            this.printDefinition("check constraint", constraintName, constraint.getDefinition());
        }
    }

    private void printColumnDataType(ColumnDataType columnDataType) {
        String databaseSpecificTypeName = columnDataType.getFullName();
        String typeName = columnDataType.getTypeName();
        String userDefined = SchemaTextFormatter.negate(columnDataType.isUserDefined(), "user defined");
        String nullable = SchemaTextFormatter.negate(columnDataType.isNullable(), "nullable");
        String autoIncrementable = SchemaTextFormatter.negate(columnDataType.isAutoIncrementable(), "auto-incrementable");
        String definedWith = "defined with ";
        definedWith = columnDataType.getCreateParameters() == null ? definedWith + "no parameters" : definedWith + columnDataType.getCreateParameters();
        this.out.println(this.formattingHelper.createNameRow(databaseSpecificTypeName, "[data type]", false));
        this.out.println(this.formattingHelper.createDetailRow("", "based on", typeName));
        this.out.println(this.formattingHelper.createDescriptionRow(userDefined));
        this.out.println(this.formattingHelper.createDescriptionRow(definedWith));
        this.out.println(this.formattingHelper.createDescriptionRow(nullable));
        this.out.println(this.formattingHelper.createDescriptionRow(autoIncrementable));
        this.out.println(this.formattingHelper.createDescriptionRow(columnDataType.getSearchable().toString()));
    }

    private void printColumnPairs(String tableName, ColumnMap ... columnPairs) {
        for (ColumnMap columnPair : columnPairs) {
            Column pkColumn = columnPair.getPrimaryKeyColumn();
            Column fkColumn = columnPair.getForeignKeyColumn();
            String pkColumnName = ((Table)pkColumn.getParent()).getName().equals(tableName) ? pkColumn.getName() : pkColumn.getFullName();
            String fkColumnName = ((Table)fkColumn.getParent()).getName().equals(tableName) ? fkColumn.getName() : fkColumn.getFullName();
            String keySequenceString = "";
            if (columnPair instanceof ForeignKeyColumnMap && ((SchemaTextOptions)this.options).isShowOrdinalNumbers()) {
                int keySequence = ((ForeignKeyColumnMap)columnPair).getKeySequence();
                keySequenceString = String.format("%2d", keySequence);
            }
            this.out.println(this.formattingHelper.createDetailRow(keySequenceString, pkColumnName + this.formattingHelper.createArrow() + fkColumnName, ""));
        }
    }

    private void printDefinition(String heading, String name, String definition) {
        if (Utility.isBlank((String)definition)) {
            return;
        }
        String definitionName = Utility.isBlank((String)name) ? "" : name;
        this.out.println(this.formattingHelper.createEmptyRow());
        this.out.println(this.formattingHelper.createNameRow(definitionName, "[" + heading + "]", false));
        this.out.println(this.formattingHelper.createDefinitionRow(definition));
    }

    private void printForeignKeys(String tableName, ForeignKey[] foreignKeys) {
        for (ForeignKey foreignKey : foreignKeys) {
            if (foreignKey == null) continue;
            String name = foreignKey.getName();
            String updateRuleString = "";
            ForeignKeyUpdateRule updateRule = foreignKey.getUpdateRule();
            if (updateRule != null && updateRule != ForeignKeyUpdateRule.unknown) {
                updateRuleString = ", on update " + updateRule.toString();
            }
            String deleteRuleString = "";
            ForeignKeyUpdateRule deleteRule = foreignKey.getDeleteRule();
            if (deleteRule != null && deleteRule != ForeignKeyUpdateRule.unknown) {
                deleteRuleString = ", on delete " + deleteRule.toString();
            }
            String ruleString = updateRule == deleteRule ? ", with " + deleteRule.toString() : updateRuleString + deleteRuleString;
            this.out.println(this.formattingHelper.createEmptyRow());
            String fkName = "";
            if (!((SchemaTextOptions)this.options).isHideForeignKeyNames()) {
                fkName = name;
            }
            String fkDetails = "[foreign key" + ruleString + "]";
            this.out.println(this.formattingHelper.createNameRow(fkName, fkDetails, false));
            ForeignKeyColumnMap[] columnPairs = foreignKey.getColumnPairs();
            this.printColumnPairs(tableName, (ColumnMap[])columnPairs);
        }
    }

    private void printIndices(Index[] indices) {
        for (Index index : indices) {
            if (index == null) continue;
            this.out.println(this.formattingHelper.createEmptyRow());
            String indexName = "";
            if (!((SchemaTextOptions)this.options).isHideIndexNames()) {
                indexName = index.getName();
            }
            IndexType indexType = index.getType();
            String indexTypeString = "";
            if (indexType != IndexType.unknown && indexType != IndexType.other) {
                indexTypeString = indexType.toString() + " ";
            }
            String indexDetails = "[" + (index.isUnique() ? "" : "non-") + "unique " + indexTypeString + "index]";
            this.out.println(this.formattingHelper.createNameRow(indexName, indexDetails, false));
            this.printTableColumns((Column[])index.getColumns());
        }
    }

    private void printLint(Table table) {
        Lint[] lints = AnalyzedDatabase.getLint(table);
        if (lints != null && lints.length > 0) {
            this.out.println(this.formattingHelper.createEmptyRow());
            this.out.println(this.formattingHelper.createNameRow("", "[lint]", false));
            for (Lint lint : lints) {
                Object lintValue = lint.getLintValue();
                if (lintValue instanceof Boolean) {
                    if (!((Boolean)lintValue).booleanValue()) continue;
                    this.out.println(this.formattingHelper.createDescriptionRow(lint.getDescription()));
                    continue;
                }
                this.out.println(this.formattingHelper.createDescriptionRow(lint.getDescription() + Utility.NEWLINE + lint.getLintValueAsString()));
            }
        }
    }

    private void printPrimaryKey(Index primaryKey) {
        if (primaryKey != null) {
            String name = primaryKey.getName();
            this.out.println(this.formattingHelper.createEmptyRow());
            String pkName = "";
            if (!((SchemaTextOptions)this.options).isHidePrimaryKeyNames()) {
                pkName = name;
            }
            if (Utility.isBlank((String)pkName)) {
                pkName = "";
            }
            this.out.println(this.formattingHelper.createNameRow(pkName, "[primary key]", false));
            this.printTableColumns((Column[])primaryKey.getColumns());
        }
    }

    private void printPrivileges(Privilege[] privileges) {
        for (Privilege privilege : privileges) {
            if (privilege == null) continue;
            this.out.println(this.formattingHelper.createEmptyRow());
            this.out.println(this.formattingHelper.createNameRow(privilege.getName(), "[privilege]", false));
            for (Privilege.Grant grant : privilege.getGrants()) {
                String grantedFrom = grant.getGrantor() + this.formattingHelper.createArrow() + grant.getGrantee() + (grant.isGrantable() ? " (grantable)" : "");
                this.out.println(this.formattingHelper.createDetailRow("", grantedFrom, ""));
            }
        }
    }

    private void printProcedureColumns(ProcedureColumn[] columns) {
        for (ProcedureColumn column : columns) {
            String columnTypeName = ((SchemaTextOptions)this.options).isShowStandardColumnTypeNames() ? column.getType().getTypeName() : column.getType().getDatabaseSpecificTypeName();
            StringBuilder columnType = new StringBuilder();
            columnType.append(columnTypeName).append(column.getWidth());
            if (column.getProcedureColumnType() != null) {
                columnType.append(", ").append(column.getProcedureColumnType().toString());
            }
            String ordinalNumberString = "";
            if (((SchemaTextOptions)this.options).isShowOrdinalNumbers()) {
                ordinalNumberString = String.valueOf(column.getOrdinalPosition() + 1);
            }
            this.out.println(this.formattingHelper.createDetailRow(ordinalNumberString, column.getName(), columnType.toString()));
        }
    }

    private void printTableColumns(Column[] columns) {
        for (Column column : columns) {
            String columnDetails;
            String columnName = column.getName();
            if (column instanceof IndexColumn) {
                columnDetails = ((IndexColumn)column).getSortSequence().name();
            } else {
                String columnTypeName = column.getType().getDatabaseSpecificTypeName();
                if (((SchemaTextOptions)this.options).isShowStandardColumnTypeNames()) {
                    columnTypeName = column.getType().getTypeName();
                }
                String columnType = columnTypeName + column.getWidth();
                String nullable = column.isNullable() ? "" : " not null";
                columnDetails = columnType + nullable;
            }
            String ordinalNumberString = "";
            if (((SchemaTextOptions)this.options).isShowOrdinalNumbers()) {
                ordinalNumberString = String.valueOf(column.getOrdinalPosition());
            }
            this.out.println(this.formattingHelper.createDetailRow(ordinalNumberString, columnName, columnDetails));
        }
    }

    private void printTriggers(Trigger[] triggers) {
        for (Trigger trigger : triggers) {
            if (trigger == null) continue;
            String timing = "";
            ConditionTimingType conditionTiming = trigger.getConditionTiming();
            EventManipulationType eventManipulationType = trigger.getEventManipulationType();
            if (conditionTiming != null && conditionTiming != ConditionTimingType.unknown && eventManipulationType != null && eventManipulationType != EventManipulationType.unknown) {
                timing = ", " + conditionTiming + " " + eventManipulationType;
            }
            String orientation = "";
            if (trigger.getActionOrientation() != null && trigger.getActionOrientation() != ActionOrientationType.unknown) {
                orientation = ", per " + trigger.getActionOrientation();
            }
            String triggerType = "[trigger" + timing + orientation + "]";
            triggerType = triggerType.toLowerCase(Locale.ENGLISH);
            String actionCondition = trigger.getActionCondition();
            String actionStatement = trigger.getActionStatement();
            this.out.println(this.formattingHelper.createEmptyRow());
            String triggerName = trigger.getName();
            this.out.println(this.formattingHelper.createNameRow(triggerName, triggerType, false));
            if (!Utility.isBlank((String)actionCondition)) {
                this.out.println(this.formattingHelper.createDescriptionRow(actionCondition));
            }
            if (Utility.isBlank((String)actionStatement)) continue;
            this.out.println(this.formattingHelper.createDescriptionRow(actionStatement));
        }
    }

    private void printWeakAssociations(Table table) {
        ColumnMap[] weakAssociations;
        String tableName = table.getName();
        for (ColumnMap weakAssociation : weakAssociations = AnalyzedDatabase.getWeakAssociations(table)) {
            this.out.println(this.formattingHelper.createEmptyRow());
            this.out.println(this.formattingHelper.createNameRow("", "[weak association]", false));
            this.printColumnPairs(tableName, weakAssociation);
        }
    }

    @Override
    public void handle(ColumnDataType columnDataType) throws SchemaCrawlerException {
        if (this.printVerboseDatabaseInfo && this.isVerbose) {
            this.out.print(this.formattingHelper.createObjectStart(""));
            this.printColumnDataType(columnDataType);
            this.out.print(this.formattingHelper.createObjectEnd());
        }
    }

    @Override
    public void handle(Procedure procedure) {
        boolean underscore = this.isNotList;
        String procedureTypeDetail = "procedure, " + procedure.getType();
        String nameRow = this.formattingHelper.createNameRow(procedure.getFullName(), "[" + procedureTypeDetail + "]", underscore);
        if (this.isNotList) {
            this.out.print(this.formattingHelper.createObjectStart(""));
        }
        this.out.println(nameRow);
        if (this.isNotList) {
            this.printProcedureColumns(procedure.getColumns());
            this.printDefinition("definition", "", procedure.getDefinition());
            if (this.isVerbose) {
                this.printDefinition("remarks", "", procedure.getRemarks());
            }
            this.out.println(this.formattingHelper.createObjectEnd());
        }
        this.out.flush();
    }

    @Override
    public void handle(Table table) {
        boolean underscore = this.isNotList;
        String nameRow = this.formattingHelper.createNameRow(table.getFullName(), "[" + table.getType() + "]", underscore);
        if (this.isNotList) {
            this.out.print(this.formattingHelper.createObjectStart(""));
        }
        this.out.println(nameRow);
        if (this.isNotList) {
            Column[] columns = table.getColumns();
            this.printTableColumns(columns);
            this.printPrimaryKey((Index)table.getPrimaryKey());
            this.printForeignKeys(table.getName(), table.getForeignKeys());
            if (this.isVerbose) {
                this.printWeakAssociations(table);
            }
            this.printIndices(table.getIndices());
            if (this.isVerbose) {
                this.printCheckConstraints(table.getCheckConstraints());
                this.printPrivileges(table.getPrivileges());
                this.printTriggers(table.getTriggers());
            }
            if (table instanceof View) {
                View view = (View)table;
                this.printDefinition("definition", "", view.getDefinition());
            }
            if (this.isVerbose) {
                String remarks;
                String tableRemarks = table.getRemarks();
                boolean hasColumnRemarks = false;
                for (Column column : columns) {
                    remarks = column.getRemarks();
                    if (Utility.isBlank((String)remarks)) continue;
                    hasColumnRemarks = true;
                    break;
                }
                if (Utility.isBlank((String)tableRemarks) && hasColumnRemarks) {
                    this.out.println(this.formattingHelper.createEmptyRow());
                    this.out.println(this.formattingHelper.createNameRow("", "[remarks]", false));
                } else {
                    this.printDefinition("remarks", "", tableRemarks);
                }
                for (Column column : columns) {
                    remarks = column.getRemarks();
                    if (Utility.isBlank((String)remarks)) continue;
                    this.out.println(this.formattingHelper.createDetailRow("", column.getName(), remarks));
                }
                this.printLint(table);
            }
            this.out.println(this.formattingHelper.createObjectEnd());
        }
        this.out.flush();
    }

    @Override
    public void handleColumnDataTypesEnd() {
    }

    @Override
    public void handleColumnDataTypesStart() {
        if (this.printVerboseDatabaseInfo && this.isVerbose) {
            this.out.println(this.formattingHelper.createHeader(TextFormattingHelper.DocumentHeaderType.subTitle, "Data Types"));
        }
    }

    @Override
    public void handleProceduresEnd() throws SchemaCrawlerException {
        if (this.isList) {
            this.out.print(this.formattingHelper.createObjectEnd());
        }
    }

    @Override
    public void handleProceduresStart() throws SchemaCrawlerException {
        this.out.println(this.formattingHelper.createHeader(TextFormattingHelper.DocumentHeaderType.subTitle, "Procedures"));
        if (this.isList) {
            this.out.print(this.formattingHelper.createObjectStart(""));
        }
    }

    @Override
    public void handleTablesEnd() throws SchemaCrawlerException {
        if (this.isList) {
            this.out.print(this.formattingHelper.createObjectEnd());
        }
    }

    @Override
    public void handleTablesStart() throws SchemaCrawlerException {
        this.out.println(this.formattingHelper.createHeader(TextFormattingHelper.DocumentHeaderType.subTitle, "Tables"));
        if (this.isList) {
            this.out.print(this.formattingHelper.createObjectStart(""));
        }
    }
}

