/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.options;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.logging.Level;
import java.util.logging.Logger;
import schemacrawler.schemacrawler.SchemaCrawlerException;
import schemacrawler.tools.options.OutputOptions;

public final class OutputWriter
extends Writer {
    private static final Logger LOGGER = Logger.getLogger(OutputWriter.class.getName());
    private final Writer writer;
    private final File outputFile;

    public OutputWriter(OutputOptions outputOptions) throws SchemaCrawlerException {
        this.outputFile = outputOptions != null ? outputOptions.getOutputFile() : null;
        this.writer = this.openOutputWriter(outputOptions);
    }

    @Override
    public Writer append(char c) throws IOException {
        return this.writer.append(c);
    }

    @Override
    public Writer append(CharSequence csq) throws IOException {
        return this.writer.append(csq);
    }

    @Override
    public Writer append(CharSequence csq, int start, int end) throws IOException {
        return this.writer.append(csq, start, end);
    }

    @Override
    public void close() throws IOException {
        if (this.writer != null) {
            this.writer.flush();
        }
        if (this.outputFile != null) {
            if (this.writer != null) {
                this.writer.close();
                LOGGER.log(Level.INFO, "Closed output writer to file, " + this.outputFile.getAbsolutePath());
            }
        } else {
            LOGGER.log(Level.INFO, "Not closing output writer, since output is to console");
        }
    }

    public boolean equals(Object obj) {
        return this.writer.equals(obj);
    }

    @Override
    public void flush() throws IOException {
        this.writer.flush();
    }

    public int hashCode() {
        return this.writer.hashCode();
    }

    public String toString() {
        return this.writer.toString();
    }

    @Override
    public void write(char[] cbuf) throws IOException {
        this.writer.write(cbuf);
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        this.writer.write(cbuf, off, len);
    }

    @Override
    public void write(int c) throws IOException {
        this.writer.write(c);
    }

    @Override
    public void write(String str) throws IOException {
        this.writer.write(str);
    }

    @Override
    public void write(String str, int off, int len) throws IOException {
        this.writer.write(str, off, len);
    }

    private Writer openOutputWriter(OutputOptions outputOptions) throws SchemaCrawlerException {
        try {
            PrintWriter writer;
            if (this.outputFile == null) {
                writer = new PrintWriter(System.out, true);
                LOGGER.log(Level.INFO, "Opened output writer to console");
            } else {
                FileWriter fileWriter = new FileWriter(this.outputFile, outputOptions.isAppendOutput());
                writer = new PrintWriter((Writer)new BufferedWriter(fileWriter), true);
                LOGGER.log(Level.INFO, "Opened output writer to file, " + this.outputFile.getAbsolutePath());
            }
            return writer;
        }
        catch (Exception e) {
            throw new SchemaCrawlerException("Could not obtain output writer", (Throwable)e);
        }
    }
}

