/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.schemacrawler;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import schemacrawler.schemacrawler.Options;
import sf.util.ObjectToString;
import sf.util.Utility;

public final class Config
extends HashMap<String, String>
implements Options {
    private static final long serialVersionUID = 8720699738076915453L;
    private static final Logger LOGGER = Logger.getLogger(Config.class.getName());

    public static Config load(InputStream configStream) {
        Properties configProperties = new Properties();
        if (configStream != null) {
            configProperties = Config.loadProperties(configProperties, configStream);
        }
        return new Config(configProperties);
    }

    public static Config load(String ... configFilenames) {
        Properties configProperties = new Properties();
        if (configFilenames != null) {
            for (String configFilename : configFilenames) {
                if (Utility.isBlank(configFilename)) continue;
                configProperties = Config.loadProperties(configProperties, new File(configFilename));
            }
        }
        return new Config(configProperties);
    }

    private static Properties loadProperties(Properties properties, File propertiesFile) {
        try {
            BufferedInputStream propertiesStream = new BufferedInputStream(new FileInputStream(propertiesFile));
            Config.loadProperties(properties, propertiesStream);
        }
        catch (FileNotFoundException e) {
            LOGGER.log(Level.WARNING, "Cannot load properties from file, " + propertiesFile.getAbsolutePath());
            LOGGER.log(Level.FINEST, e.getMessage(), e);
        }
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties loadProperties(Properties properties, InputStream propertiesStream) {
        try {
            properties.load(propertiesStream);
            propertiesStream.close();
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Error loading properties", e);
        }
        finally {
            try {
                if (propertiesStream != null) {
                    propertiesStream.close();
                }
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "Error closing stream", e);
            }
        }
        return properties;
    }

    private static Map<String, String> propertiesMap(Properties properties) {
        HashMap<String, String> propertiesMap = new HashMap<String, String>();
        if (properties != null) {
            Set<Map.Entry<Object, Object>> entries = properties.entrySet();
            for (Map.Entry<Object, Object> entry : entries) {
                propertiesMap.put((String)entry.getKey(), (String)entry.getValue());
            }
        }
        return propertiesMap;
    }

    public Config() {
    }

    public Config(Properties properties) {
        super(Config.propertiesMap(properties));
    }

    public boolean getBooleanValue(String propertyName) {
        return Boolean.parseBoolean(this.getStringValue(propertyName, "false"));
    }

    public int getIntegerValue(String propertyName) {
        return Integer.parseInt(this.getStringValue(propertyName, null));
    }

    public String getStringValue(String propertyName, String defaultValue) {
        String value = (String)this.get(propertyName);
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }

    @Override
    public String toString() {
        return ObjectToString.toString(this);
    }
}

