/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import schemacrawler.crawl.DatabaseInfoRetriever;
import schemacrawler.crawl.MutableDatabase;
import schemacrawler.crawl.MutableProcedure;
import schemacrawler.crawl.MutableSchema;
import schemacrawler.crawl.MutableTable;
import schemacrawler.crawl.MutableView;
import schemacrawler.crawl.NamedObjectList;
import schemacrawler.crawl.NamedObjectSort;
import schemacrawler.crawl.ProcedureExRetriever;
import schemacrawler.crawl.ProcedureRetriever;
import schemacrawler.crawl.ResultsRetriever;
import schemacrawler.crawl.RetrieverConnection;
import schemacrawler.crawl.SchemaReference;
import schemacrawler.crawl.SchemaRetriever;
import schemacrawler.crawl.TableExRetriever;
import schemacrawler.crawl.TableRetriever;
import schemacrawler.crawl.TablesGraph;
import schemacrawler.schema.Column;
import schemacrawler.schema.Database;
import schemacrawler.schema.DependantObject;
import schemacrawler.schema.Procedure;
import schemacrawler.schema.ProcedureColumn;
import schemacrawler.schema.ResultsColumns;
import schemacrawler.schema.Table;
import schemacrawler.schema.View;
import schemacrawler.schemacrawler.InclusionRule;
import schemacrawler.schemacrawler.SchemaCrawlerException;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;
import schemacrawler.schemacrawler.SchemaInfoLevel;

public final class SchemaCrawler {
    private static final Logger LOGGER = Logger.getLogger(SchemaCrawler.class.getName());
    private final Connection connection;

    public static ResultsColumns getResultColumns(ResultSet resultSet) {
        ResultsColumns resultColumns = null;
        try {
            ResultsRetriever resultsRetriever = new ResultsRetriever(resultSet);
            resultColumns = resultsRetriever.retrieveResults();
        }
        catch (SQLException e) {
            LOGGER.log(Level.WARNING, e.getMessage(), e);
            resultColumns = null;
        }
        return resultColumns;
    }

    private static void crawlColumnDataTypes(MutableDatabase database, RetrieverConnection retrieverConnection, SchemaCrawlerOptions options) throws SchemaCrawlerException {
        try {
            SchemaInfoLevel infoLevel = options.getSchemaInfoLevel();
            DatabaseInfoRetriever retriever = new DatabaseInfoRetriever(retrieverConnection, database);
            if (infoLevel.isRetrieveColumnDataTypes()) {
                retriever.retrieveSystemColumnDataTypes();
            }
            if (infoLevel.isRetrieveUserDefinedColumnDataTypes()) {
                for (SchemaReference schemaNameObject : retriever.getSchemaNames()) {
                    retriever.retrieveUserDefinedColumnDataTypes(schemaNameObject.getCatalogName(), schemaNameObject.getSchemaName());
                }
            }
        }
        catch (SQLException e) {
            throw new SchemaCrawlerException("Exception retrieving column data type information", e);
        }
    }

    private static void crawlDatabaseInfo(MutableDatabase database, RetrieverConnection retrieverConnection, SchemaCrawlerOptions options) throws SchemaCrawlerException {
        try {
            SchemaInfoLevel infoLevel = options.getSchemaInfoLevel();
            DatabaseInfoRetriever retriever = new DatabaseInfoRetriever(retrieverConnection, database);
            if (infoLevel.isRetrieveSchemaCrawlerInfo()) {
                retriever.retrieveSchemaCrawlerInfo();
                if (infoLevel.isRetrieveAdditionalSchemaCrawlerInfo()) {
                    retriever.retrieveAdditionalSchemaCrawlerInfo();
                }
            }
            if (infoLevel.isRetrieveDatabaseInfo()) {
                retriever.retrieveDatabaseInfo();
                if (infoLevel.isRetrieveAdditionalDatabaseInfo()) {
                    retriever.retrieveAdditionalDatabaseInfo();
                }
            }
            if (infoLevel.isRetrieveJdbcDriverInfo()) {
                retriever.retrieveJdbcDriverInfo();
                if (infoLevel.isRetrieveAdditionalJdbcDriverInfo()) {
                    retriever.retrieveAdditionalJdbcDriverInfo();
                }
            }
        }
        catch (SQLException e) {
            throw new SchemaCrawlerException("Exception retrieving database information", e);
        }
    }

    private static void crawlProcedures(MutableDatabase database, RetrieverConnection retrieverConnection, SchemaCrawlerOptions options) throws SchemaCrawlerException {
        SchemaInfoLevel infoLevel = options.getSchemaInfoLevel();
        boolean retrieveProcedures = infoLevel.isRetrieveProcedures();
        if (!retrieveProcedures) {
            return;
        }
        try {
            ProcedureRetriever retriever = new ProcedureRetriever(retrieverConnection, database);
            ProcedureExRetriever retrieverExtra = new ProcedureExRetriever(retrieverConnection, database);
            for (SchemaReference schemaNameObject : retriever.getSchemaNames()) {
                retriever.retrieveProcedures(schemaNameObject.getCatalogName(), schemaNameObject.getSchemaName(), options.getProcedureInclusionRule());
            }
            NamedObjectList<MutableProcedure> allProcedures = database.getAllProcedures();
            for (MutableProcedure procedure : allProcedures) {
                if (infoLevel.isRetrieveProcedureColumns()) {
                    retriever.retrieveProcedureColumns(procedure, options.getProcedureColumnInclusionRule());
                }
                if (SchemaCrawler.grepMatch(options, procedure)) continue;
                ((MutableSchema)procedure.getSchema()).removeProcedure(procedure);
                allProcedures.remove(procedure);
            }
            if (infoLevel.isRetrieveProcedureInformation()) {
                retrieverExtra.retrieveProcedureInformation();
            }
            for (MutableProcedure procedure : allProcedures) {
                procedure.setColumnComparator(NamedObjectSort.getNamedObjectSort(options.isAlphabeticalSortForProcedureColumns()));
            }
        }
        catch (SQLException e) {
            throw new SchemaCrawlerException("Exception retrieving procedures", e);
        }
    }

    private static void crawlSchemas(MutableDatabase database, RetrieverConnection retrieverConnection, SchemaCrawlerOptions options) throws SchemaCrawlerException {
        try {
            SchemaRetriever retriever = new SchemaRetriever(retrieverConnection, database);
            retriever.retrieveSchemas(options.getSchemaInclusionRule());
        }
        catch (SQLException e) {
            throw new SchemaCrawlerException("Exception retrieving database information", e);
        }
    }

    private static void crawlTables(MutableDatabase database, RetrieverConnection retrieverConnection, SchemaCrawlerOptions options) throws SchemaCrawlerException {
        SchemaInfoLevel infoLevel = options.getSchemaInfoLevel();
        boolean retrieveTables = infoLevel.isRetrieveTables();
        if (!retrieveTables) {
            return;
        }
        try {
            NamedObjectSort tablesSort;
            TableRetriever retriever = new TableRetriever(retrieverConnection, database);
            TableExRetriever retrieverExtra = new TableExRetriever(retrieverConnection, database);
            for (SchemaReference schemaNameObject : retriever.getSchemaNames()) {
                retriever.retrieveTables(schemaNameObject.getCatalogName(), schemaNameObject.getSchemaName(), options.getTableNamePattern(), options.getTableTypes(), options.getTableInclusionRule());
            }
            NamedObjectList<MutableTable> allTables = database.getAllTables();
            for (MutableTable table : allTables) {
                if (infoLevel.isRetrieveTableColumns()) {
                    retriever.retrieveColumns(table, options.getColumnInclusionRule());
                }
                if (SchemaCrawler.grepMatch(options, table)) continue;
                ((MutableSchema)table.getSchema()).removeTable(table);
                allTables.remove(table);
            }
            if (infoLevel.isRetrieveCheckConstraintInformation()) {
                retrieverExtra.retrieveCheckConstraintInformation();
            }
            if (infoLevel.isRetrieveTriggerInformation()) {
                retrieverExtra.retrieveTriggerInformation();
            }
            if (infoLevel.isRetrieveViewInformation()) {
                retrieverExtra.retrieveViewInformation();
            }
            if (infoLevel.isRetrieveTablePrivileges()) {
                retrieverExtra.retrieveTablePrivileges();
            }
            if (infoLevel.isRetrieveTableColumnPrivileges()) {
                retrieverExtra.retrieveTableColumnPrivileges();
            }
            if ((tablesSort = NamedObjectSort.getNamedObjectSort(options.isAlphabeticalSortForTables())) == NamedObjectSort.natural && !infoLevel.isRetrieveForeignKeys()) {
                LOGGER.log(Level.WARNING, "Foreign-keys are not being retrieved, so tables cannot be sorted using the natural sort order");
            }
            for (MutableTable table : allTables) {
                boolean isView = table instanceof MutableView;
                if (!isView && infoLevel.isRetrieveTableColumns()) {
                    retriever.retrievePrimaryKey(table);
                    if (infoLevel.isRetrieveIndices()) {
                        retriever.retrieveIndices(table, true);
                        retriever.retrieveIndices(table, false);
                        table.replacePrimaryKey();
                    }
                    if (infoLevel.isRetrieveForeignKeys()) {
                        retriever.retrieveForeignKeys(table);
                    }
                }
                ((MutableSchema)table.getSchema()).setTablesSortOrder(tablesSort);
                table.setColumnsSortOrder(NamedObjectSort.getNamedObjectSort(options.isAlphabeticalSortForTableColumns()));
                table.setForeignKeysSortOrder(NamedObjectSort.getNamedObjectSort(options.isAlphabeticalSortForForeignKeys()));
                table.setIndicesSortOrder(NamedObjectSort.getNamedObjectSort(options.isAlphabeticalSortForIndexes()));
            }
            allTables.setSortOrder(tablesSort);
            TablesGraph tablesGraph = new TablesGraph(allTables);
            tablesGraph.setTablesSortIndices();
        }
        catch (SQLException e) {
            throw new SchemaCrawlerException("Exception retrieving tables", e);
        }
    }

    private static boolean grepMatch(SchemaCrawlerOptions options, Procedure procedure) {
        boolean include;
        ProcedureColumn[] columns;
        boolean invertMatch = options.isGrepInvertMatch();
        boolean checkIncludeForColumns = options.isGrepProcedureColumns();
        boolean checkIncludeForDefinitions = options.isGrepDefinitions();
        InclusionRule grepProcedureColumnInclusionRule = options.getGrepProcedureColumnInclusionRule();
        InclusionRule grepDefinitionInclusionRule = options.getGrepDefinitionInclusionRule();
        if (!checkIncludeForColumns && !checkIncludeForDefinitions) {
            return true;
        }
        boolean includeForColumns = false;
        boolean includeForDefinitions = false;
        for (ProcedureColumn column : columns = procedure.getColumns()) {
            if (!checkIncludeForColumns || !grepProcedureColumnInclusionRule.include(column.getFullName())) continue;
            includeForColumns = true;
            break;
        }
        if (checkIncludeForDefinitions) {
            if (grepDefinitionInclusionRule.include(procedure.getRemarks())) {
                includeForDefinitions = true;
            }
            if (grepDefinitionInclusionRule.include(procedure.getDefinition())) {
                includeForDefinitions = true;
            }
        }
        boolean bl = include = includeForColumns || includeForDefinitions;
        if (invertMatch) {
            boolean bl2 = include = !include;
        }
        if (!include) {
            LOGGER.log(Level.FINE, "Removing procedure " + procedure + " since it does not match the grep pattern");
        }
        return include;
    }

    private static boolean grepMatch(SchemaCrawlerOptions options, Table table) {
        boolean include;
        boolean invertMatch = options.isGrepInvertMatch();
        boolean checkIncludeForColumns = options.isGrepColumns();
        boolean checkIncludeForDefinitions = options.isGrepDefinitions();
        InclusionRule grepColumnInclusionRule = options.getGrepColumnInclusionRule();
        InclusionRule grepDefinitionInclusionRule = options.getGrepDefinitionInclusionRule();
        if (!checkIncludeForColumns && !checkIncludeForDefinitions) {
            return true;
        }
        boolean includeForColumns = false;
        boolean includeForDefinitions = false;
        Column[] columns = table.getColumns();
        for (Column column : columns) {
            if (checkIncludeForColumns && grepColumnInclusionRule.include(column.getFullName())) {
                includeForColumns = true;
                break;
            }
            if (!checkIncludeForDefinitions || !grepDefinitionInclusionRule.include(column.getRemarks())) continue;
            includeForDefinitions = true;
            break;
        }
        if (checkIncludeForDefinitions) {
            if (grepDefinitionInclusionRule.include(table.getRemarks())) {
                includeForDefinitions = true;
            }
            if (table instanceof View && grepDefinitionInclusionRule.include(((View)table).getDefinition())) {
                includeForDefinitions = true;
            }
            for (DependantObject<Table> dependantObject : table.getTriggers()) {
                if (!grepDefinitionInclusionRule.include(dependantObject.getActionStatement())) continue;
                includeForDefinitions = true;
                break;
            }
        }
        boolean bl = include = checkIncludeForColumns && includeForColumns || checkIncludeForDefinitions && includeForDefinitions;
        if (invertMatch) {
            boolean bl2 = include = !include;
        }
        if (!include) {
            LOGGER.log(Level.FINE, "Removing table " + table + " since it does not match the grep pattern");
        }
        return include;
    }

    public SchemaCrawler(Connection connection) throws SchemaCrawlerException {
        if (connection == null) {
            throw new SchemaCrawlerException("No connection specified");
        }
        this.connection = connection;
    }

    public Database crawl(SchemaCrawlerOptions options) throws SchemaCrawlerException {
        MutableDatabase database = new MutableDatabase("database");
        RetrieverConnection retrieverConnection = null;
        try {
            SchemaCrawlerOptions schemaCrawlerOptions = options;
            if (schemaCrawlerOptions == null) {
                schemaCrawlerOptions = new SchemaCrawlerOptions();
            }
            retrieverConnection = new RetrieverConnection(this.connection, schemaCrawlerOptions);
            SchemaCrawler.crawlSchemas(database, retrieverConnection, schemaCrawlerOptions);
            SchemaCrawler.crawlDatabaseInfo(database, retrieverConnection, schemaCrawlerOptions);
            SchemaCrawler.crawlColumnDataTypes(database, retrieverConnection, schemaCrawlerOptions);
            SchemaCrawler.crawlTables(database, retrieverConnection, schemaCrawlerOptions);
            SchemaCrawler.crawlProcedures(database, retrieverConnection, schemaCrawlerOptions);
            return database;
        }
        catch (SQLException e) {
            throw new SchemaCrawlerException("Database access exception", e);
        }
    }
}

