/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.integration.serialization;

import java.io.Writer;
import java.sql.Connection;
import java.util.logging.Logger;
import schemacrawler.schema.Database;
import schemacrawler.tools.executable.BaseExecutable;
import schemacrawler.tools.integration.serialization.XmlDatabase;
import schemacrawler.tools.options.OutputWriter;
import sf.util.Utility;

public final class SerializationExecutable
extends BaseExecutable {
    private static final Logger LOGGER = Logger.getLogger(SerializationExecutable.class.getName());

    public SerializationExecutable() {
        this(null);
    }

    public SerializationExecutable(String command) {
        super(command);
    }

    protected void executeOn(Database db, Connection connection) throws Exception {
        XmlDatabase database;
        OutputFormat outputFormat;
        String outputFormatString = this.outputOptions.getOutputFormatValue();
        if (Utility.isBlank((String)outputFormatString)) {
            outputFormat = OutputFormat.xml;
        } else {
            try {
                outputFormat = OutputFormat.valueOf(outputFormatString);
            }
            catch (IllegalArgumentException e) {
                outputFormat = OutputFormat.xml;
            }
        }
        OutputWriter writer = new OutputWriter(this.outputOptions);
        switch (outputFormat) {
            case xml: {
                database = new XmlDatabase(db);
                break;
            }
            default: {
                database = new XmlDatabase(db);
            }
        }
        database.save((Writer)writer);
        writer.close();
    }

    static enum OutputFormat {
        xml,
        json;

    }
}

