/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.integration.graph;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import sf.util.Utility;

final class GraphGenerator {
    private static final Logger LOGGER = Logger.getLogger(GraphGenerator.class.getName());
    private final File dotFile;
    private final String graphOutputFormat;
    private final File diagramFile;

    GraphGenerator(File dotFile, String outputFormat, File diagramOutputFile) throws IOException {
        if (dotFile == null || dotFile.isDirectory() || !dotFile.exists() || !dotFile.canRead()) {
            throw new IOException("Cannot read the input DOT file, " + dotFile);
        }
        this.dotFile = dotFile;
        this.graphOutputFormat = this.determineGraphOutputFormat(outputFormat);
        this.diagramFile = this.determineDiagramFile(diagramOutputFile);
    }

    private File determineDiagramFile(File diagramOutputFile) {
        File diagramFile = diagramOutputFile == null ? new File(".", "schemacrawler." + UUID.randomUUID() + "." + this.graphOutputFormat) : diagramOutputFile;
        return diagramFile;
    }

    private String determineGraphOutputFormat(String outputFormat) {
        String graphOutputFormat = outputFormat;
        List<String> outputFormats = Arrays.asList("canon", "cmap", "cmapx", "cmapx_np", "dot", "eps", "fig", "gd", "gd2", "gif", "gv", "imap", "imap_np", "ismap", "jpe", "jpeg", "jpg", "pdf", "plain", "plain-ext", "png", "ps", "ps2", "svg", "svgz", "tk", "vml", "vmlz", "vrml", "wbmp", "xdot");
        if (Utility.isBlank((String)graphOutputFormat) || !outputFormats.contains(graphOutputFormat)) {
            graphOutputFormat = "png";
        }
        return graphOutputFormat;
    }

    void generateDiagram() throws IOException {
        String graphGenerator = System.getProperty("schemacrawler.graph_generator", "dot");
        Object[] command = new String[]{graphGenerator, "-q", "-T" + this.graphOutputFormat, "-o", this.diagramFile.getAbsolutePath(), this.dotFile.getAbsolutePath()};
        LOGGER.log(Level.CONFIG, "Executing: " + Arrays.toString(command));
        ExecutorService threadPool = Executors.newFixedThreadPool(2);
        try {
            Process process = new ProcessBuilder((String[])command).start();
            final class StreamReader
            implements Callable<String> {
                private final InputStream in;

                StreamReader(InputStream in) {
                    this.in = in;
                }

                @Override
                public String call() throws Exception {
                    BufferedReader reader = new BufferedReader(new InputStreamReader(this.in));
                    return Utility.readFully((Reader)reader);
                }
            }
            FutureTask<String> inReaderTask = new FutureTask<String>(new StreamReader(process.getInputStream()));
            threadPool.execute(inReaderTask);
            FutureTask<String> errReaderTask = new FutureTask<String>(new StreamReader(process.getErrorStream()));
            threadPool.execute(errReaderTask);
            int exitCode = process.waitFor();
            String processOutput = inReaderTask.get();
            if (!Utility.isBlank((String)processOutput)) {
                LOGGER.log(Level.INFO, processOutput);
            }
            String processError = errReaderTask.get();
            if (exitCode != 0) {
                throw new IOException(String.format("Process returned exit code %d%n%s", exitCode, processError));
            }
            if (!Utility.isBlank((String)processError)) {
                LOGGER.log(Level.WARNING, processError);
            }
        }
        catch (SecurityException e) {
            throw new IOException(e.getMessage(), e);
        }
        catch (ExecutionException e) {
            throw new IOException(e.getMessage(), e);
        }
        catch (InterruptedException e) {
            throw new IOException(e.getMessage(), e);
        }
        finally {
            threadPool.shutdown();
        }
    }
}

