/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import schemacrawler.crawl.AbstractNamedObject;
import schemacrawler.crawl.ColumnDataTypes;
import schemacrawler.crawl.MutableColumnDataType;
import schemacrawler.crawl.MutableDatabaseInfo;
import schemacrawler.crawl.MutableJdbcDriverInfo;
import schemacrawler.crawl.MutableProcedure;
import schemacrawler.crawl.MutableSchema;
import schemacrawler.crawl.MutableSchemaCrawlerInfo;
import schemacrawler.crawl.MutableSynonym;
import schemacrawler.crawl.MutableTable;
import schemacrawler.crawl.NamedObjectList;
import schemacrawler.crawl.SchemaReference;
import schemacrawler.schema.ColumnDataType;
import schemacrawler.schema.Database;
import schemacrawler.schema.Procedure;
import schemacrawler.schema.Schema;
import schemacrawler.schema.Synonym;
import schemacrawler.schema.Table;

final class MutableDatabase
extends AbstractNamedObject
implements Database {
    private static final long serialVersionUID = 4051323422934251828L;
    private final MutableDatabaseInfo databaseInfo;
    private final MutableJdbcDriverInfo jdbcDriverInfo;
    private final MutableSchemaCrawlerInfo schemaCrawlerInfo;
    private final ColumnDataTypes systemColumnDataTypes = new ColumnDataTypes();
    private final Map<SchemaReference, MutableSchema> schemaRefsCache;

    MutableDatabase(String name) {
        super(name);
        this.databaseInfo = new MutableDatabaseInfo();
        this.jdbcDriverInfo = new MutableJdbcDriverInfo();
        this.schemaCrawlerInfo = new MutableSchemaCrawlerInfo();
        this.schemaRefsCache = new HashMap<SchemaReference, MutableSchema>();
    }

    @Override
    public MutableDatabaseInfo getDatabaseInfo() {
        return this.databaseInfo;
    }

    @Override
    public MutableJdbcDriverInfo getJdbcDriverInfo() {
        return this.jdbcDriverInfo;
    }

    @Override
    public MutableSchema getSchema(String name) {
        Collection<SchemaReference> schemaRefs = this.getSchemaNames();
        for (SchemaReference schemaRef : schemaRefs) {
            if (!schemaRef.getFullName().equals(name)) continue;
            return this.schemaRefsCache.get(schemaRef);
        }
        return null;
    }

    @Override
    public MutableSchemaCrawlerInfo getSchemaCrawlerInfo() {
        return this.schemaCrawlerInfo;
    }

    @Override
    public Schema[] getSchemas() {
        ArrayList<MutableSchema> schemas = new ArrayList<MutableSchema>(this.schemaRefsCache.values());
        Collections.sort(schemas);
        return schemas.toArray(new Schema[schemas.size()]);
    }

    @Override
    public MutableColumnDataType getSystemColumnDataType(String name) {
        return (MutableColumnDataType)this.systemColumnDataTypes.lookup(name);
    }

    @Override
    public ColumnDataType[] getSystemColumnDataTypes() {
        return this.systemColumnDataTypes.values().toArray(new ColumnDataType[this.systemColumnDataTypes.size()]);
    }

    MutableSchema addSchema(SchemaReference schemaRef) {
        MutableSchema schema = new MutableSchema(schemaRef);
        this.schemaRefsCache.put(schemaRef, schema);
        return schema;
    }

    MutableSchema addSchema(String catalogName, String schemaName) {
        return this.addSchema(new SchemaReference(catalogName, schemaName));
    }

    void addSystemColumnDataType(MutableColumnDataType columnDataType) {
        if (columnDataType != null) {
            this.systemColumnDataTypes.add(columnDataType);
        }
    }

    NamedObjectList<MutableProcedure> getAllProcedures() {
        NamedObjectList<MutableProcedure> procedures = new NamedObjectList<MutableProcedure>();
        for (Schema schema : this.getSchemas()) {
            for (Procedure procedure : schema.getProcedures()) {
                procedures.add((MutableProcedure)procedure);
            }
        }
        return procedures;
    }

    NamedObjectList<MutableSynonym> getAllSynonyms() {
        NamedObjectList<MutableSynonym> synonyms = new NamedObjectList<MutableSynonym>();
        for (Schema schema : this.getSchemas()) {
            for (Synonym synonym : schema.getSynonyms()) {
                synonyms.add((MutableSynonym)synonym);
            }
        }
        return synonyms;
    }

    NamedObjectList<MutableTable> getAllTables() {
        NamedObjectList<MutableTable> tables = new NamedObjectList<MutableTable>();
        for (Schema schema : this.getSchemas()) {
            for (Table table : schema.getTables()) {
                tables.add((MutableTable)table);
            }
        }
        return tables;
    }

    MutableSchema getSchema(SchemaReference schemaRef) {
        return this.schemaRefsCache.get(schemaRef);
    }

    Collection<SchemaReference> getSchemaNames() {
        return this.schemaRefsCache.keySet();
    }

    ColumnDataTypes getSystemColumnDataTypesList() {
        return this.systemColumnDataTypes;
    }
}

