/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.text.operation;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import schemacrawler.schemacrawler.SchemaCrawlerException;
import schemacrawler.tools.options.OutputOptions;
import schemacrawler.tools.text.base.BaseJsonFormatter;
import schemacrawler.tools.text.operation.DataResultSet;
import schemacrawler.tools.text.operation.Operation;
import schemacrawler.tools.text.operation.OperationOptions;
import schemacrawler.tools.text.utility.org.json.JSONArray;
import schemacrawler.tools.text.utility.org.json.JSONException;
import schemacrawler.tools.text.utility.org.json.JSONObject;
import schemacrawler.tools.traversal.DataTraversalHandler;

final class DataJsonFormatter
extends BaseJsonFormatter<OperationOptions>
implements DataTraversalHandler {
    private final Operation operation;
    private final JSONArray jsonDataArray;

    DataJsonFormatter(Operation operation, OperationOptions options, OutputOptions outputOptions) throws SchemaCrawlerException {
        super(options, false, outputOptions);
        this.operation = operation;
        this.jsonDataArray = new JSONArray();
        try {
            if (operation != null) {
                this.jsonRoot.put("description", operation.getDescription());
            }
            this.jsonRoot.put("data", this.jsonDataArray);
        }
        catch (JSONException e) {
            throw new SchemaCrawlerException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void handleData(String title, ResultSet rows) throws SchemaCrawlerException {
        try {
            JSONObject jsonData = new JSONObject();
            jsonData.put("title", title);
            if (this.operation == Operation.count) {
                long aggregate = this.handleAggregateOperationForTable(title, rows);
                jsonData.put("value", aggregate);
            } else {
                try {
                    DataResultSet dataRows = new DataResultSet(rows, ((OperationOptions)this.options).isShowLobs());
                    jsonData.put("columnNames", new JSONArray(dataRows.getColumnNames()));
                    JSONArray jsonRows = ((OperationOptions)this.options).isMergeRows() && dataRows.width() > 1 ? this.iterateRowsAndMerge(dataRows) : this.iterateRows(dataRows);
                    jsonData.put("rows", jsonRows);
                }
                catch (SQLException e) {
                    throw new SchemaCrawlerException(e.getMessage(), (Throwable)e);
                }
            }
            this.jsonDataArray.put(jsonData);
        }
        catch (JSONException e) {
            throw new SchemaCrawlerException("Could not convert data to JSON", (Throwable)e);
        }
    }

    private JSONArray doHandleOneRow(List<String> row, String lastColumnData) {
        if (row.isEmpty()) {
            return new JSONArray();
        }
        ArrayList<String> outputRow = new ArrayList<String>();
        outputRow.addAll(row);
        outputRow.add(lastColumnData);
        return new JSONArray(outputRow);
    }

    private long handleAggregateOperationForTable(String title, ResultSet results) throws SchemaCrawlerException {
        try {
            long aggregate = 0L;
            if (results.next()) {
                aggregate = results.getLong(1);
            }
            return aggregate;
        }
        catch (SQLException e) {
            throw new SchemaCrawlerException("Could not obtain aggregate data", (Throwable)e);
        }
    }

    private JSONArray iterateRows(DataResultSet dataRows) throws SQLException {
        JSONArray jsonRows = new JSONArray();
        while (dataRows.next()) {
            List<String> currentRow = dataRows.row();
            jsonRows.put(new JSONArray(currentRow));
        }
        return jsonRows;
    }

    private JSONArray iterateRowsAndMerge(DataResultSet dataRows) throws SQLException {
        JSONArray jsonRows = new JSONArray();
        List<String> previousRow = new ArrayList<String>();
        StringBuilder currentRowLastColumn = new StringBuilder();
        while (dataRows.next()) {
            List<String> currentRow = dataRows.row();
            String lastColumnDataString = currentRow.remove(currentRow.size() - 1);
            if (((Object)currentRow).equals(previousRow)) {
                currentRowLastColumn.append(lastColumnDataString);
            } else {
                JSONArray jsonRow = this.doHandleOneRow(previousRow, currentRowLastColumn.toString());
                jsonRows.put(jsonRow);
                currentRowLastColumn = new StringBuilder();
                currentRowLastColumn.append(lastColumnDataString);
            }
            previousRow = currentRow;
        }
        JSONArray jsonRow = this.doHandleOneRow(previousRow, currentRowLastColumn.toString());
        jsonRows.put(jsonRow);
        return jsonRows;
    }
}

