/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.text.base;

import java.util.Arrays;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import schemacrawler.schema.DatabaseInfo;
import schemacrawler.schema.DatabaseProperty;
import schemacrawler.schema.JdbcDriverInfo;
import schemacrawler.schema.JdbcDriverProperty;
import schemacrawler.schema.SchemaCrawlerInfo;
import schemacrawler.schemacrawler.Options;
import schemacrawler.schemacrawler.SchemaCrawlerException;
import schemacrawler.tools.options.OutputOptions;
import schemacrawler.tools.text.base.BaseFormatter;
import schemacrawler.tools.text.utility.org.json.JSONArray;
import schemacrawler.tools.text.utility.org.json.JSONException;
import schemacrawler.tools.text.utility.org.json.JSONObject;

public abstract class BaseJsonFormatter<O extends Options>
extends BaseFormatter<O> {
    protected static final Logger LOGGER = Logger.getLogger(BaseJsonFormatter.class.getName());
    protected final JSONObject jsonRoot = new JSONObject();

    protected BaseJsonFormatter(O options, boolean printVerboseDatabaseInfo, OutputOptions outputOptions) throws SchemaCrawlerException {
        super(options, printVerboseDatabaseInfo, outputOptions);
    }

    @Override
    public void begin() throws SchemaCrawlerException {
        if (!this.outputOptions.isNoHeader()) {
            this.out.println("[");
        }
    }

    @Override
    public void end() throws SchemaCrawlerException {
        try {
            this.jsonRoot.write(this.out, 2);
            if (this.outputOptions.isNoFooter()) {
                this.out.println(",");
            } else {
                this.out.println("]");
            }
            this.out.close();
        }
        catch (JSONException e) {
            throw new SchemaCrawlerException("Could not write database", (Throwable)e);
        }
    }

    @Override
    public void handle(DatabaseInfo dbInfo) {
        if (this.outputOptions.isNoInfo() || dbInfo == null) {
            return;
        }
        try {
            JSONObject jsonDbInfo = new JSONObject();
            this.jsonRoot.put("databaseInfo", jsonDbInfo);
            jsonDbInfo.put("databaseProductName", dbInfo.getProductName());
            jsonDbInfo.put("databaseProductVersion", dbInfo.getProductVersion());
            jsonDbInfo.put("databaseUserName", dbInfo.getUserName());
            if (this.printVerboseDatabaseInfo && dbInfo.getProperties().length > 0) {
                JSONArray jsonDbProperties = new JSONArray();
                jsonDbInfo.put("databaseProperties", jsonDbProperties);
                for (DatabaseProperty property : dbInfo.getProperties()) {
                    JSONObject jsonDbProperty = new JSONObject();
                    jsonDbProperties.put(jsonDbProperty);
                    jsonDbProperty.put("name", property.getName());
                    jsonDbProperty.put("description", property.getDescription());
                    jsonDbProperty.put("value", property.getValue());
                }
            }
        }
        catch (JSONException e) {
            LOGGER.log(Level.FINER, "Error outputting DatabaseInfo: " + e.getMessage(), e);
        }
    }

    @Override
    public void handle(JdbcDriverInfo driverInfo) {
        if (this.outputOptions.isNoInfo() || driverInfo == null) {
            return;
        }
        try {
            JSONObject jsonDriverInfo = new JSONObject();
            this.jsonRoot.put("jdbcDriverInfo", jsonDriverInfo);
            jsonDriverInfo.put("driverName", driverInfo.getDriverName());
            jsonDriverInfo.put("driverVersion", driverInfo.getDriverVersion());
            jsonDriverInfo.put("driverClassName", driverInfo.getDriverClassName());
            jsonDriverInfo.put("url", driverInfo.getConnectionUrl());
            jsonDriverInfo.put("isJDBCCompliant", Boolean.toString(driverInfo.isJdbcCompliant()));
            JdbcDriverProperty[] jdbcDriverProperties = driverInfo.getDriverProperties();
            if (this.printVerboseDatabaseInfo && jdbcDriverProperties.length > 0) {
                JSONArray jsonJdbcDriverProperties = new JSONArray();
                jsonDriverInfo.put("jdbcDriverProperties", jsonJdbcDriverProperties);
                for (JdbcDriverProperty driverProperty : jdbcDriverProperties) {
                    jsonJdbcDriverProperties.put(this.printJdbcDriverProperty(driverProperty));
                }
            }
        }
        catch (JSONException e) {
            LOGGER.log(Level.FINER, "Error outputting JdbcDriverInfo: " + e.getMessage(), e);
        }
    }

    @Override
    public void handle(SchemaCrawlerInfo schemaCrawlerInfo) {
        if (this.outputOptions.isNoInfo() || schemaCrawlerInfo == null) {
            return;
        }
        try {
            TreeMap systemProperties;
            JSONObject jsonSchemaCrawlerInfo = new JSONObject();
            this.jsonRoot.put("schemaCrawlerInfo", jsonSchemaCrawlerInfo);
            jsonSchemaCrawlerInfo.put("productName", schemaCrawlerInfo.getSchemaCrawlerProductName());
            jsonSchemaCrawlerInfo.put("productVersion", schemaCrawlerInfo.getSchemaCrawlerVersion());
            if (this.printVerboseDatabaseInfo && !(systemProperties = new TreeMap(schemaCrawlerInfo.getSystemProperties())).isEmpty()) {
                JSONObject jsonSystemProperties = new JSONObject();
                jsonSchemaCrawlerInfo.put("systemProperties", jsonSystemProperties);
                for (Map.Entry systemProperty : systemProperties.entrySet()) {
                    jsonSystemProperties.put((String)systemProperty.getKey(), systemProperty.getValue());
                }
            }
        }
        catch (JSONException e) {
            LOGGER.log(Level.FINER, "Error outputting SchemaCrawlerInfo: " + e.getMessage(), e);
        }
    }

    @Override
    public void handleInfoEnd() throws SchemaCrawlerException {
    }

    @Override
    public void handleInfoStart() throws SchemaCrawlerException {
    }

    private JSONObject printJdbcDriverProperty(JdbcDriverProperty driverProperty) {
        JSONObject jsonDriverProperty = new JSONObject();
        try {
            String[] choices = driverProperty.getChoices();
            if (choices != null && choices.length > 0) {
                jsonDriverProperty.put("choices", Arrays.asList(choices));
            }
            String value = driverProperty.getValue();
            jsonDriverProperty.put("name", driverProperty.getName());
            jsonDriverProperty.put("description", driverProperty.getDescription());
            jsonDriverProperty.put("required", driverProperty.isRequired());
            jsonDriverProperty.put("value", value);
        }
        catch (JSONException e) {
            LOGGER.log(Level.FINER, "Error outputting JdbcDriverProperty: " + e.getMessage(), e);
        }
        return jsonDriverProperty;
    }
}

