/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.executable;

import java.lang.reflect.Constructor;
import java.util.logging.Level;
import java.util.logging.Logger;
import schemacrawler.schemacrawler.SchemaCrawlerException;
import schemacrawler.tools.executable.CommandProvider;
import schemacrawler.tools.executable.Executable;

class ExecutableCommandProvider
implements CommandProvider {
    private static final Logger LOGGER = Logger.getLogger(ExecutableCommandProvider.class.getName());
    private final String command;
    private final String executableClassName;

    ExecutableCommandProvider(String command, String executableClassName) {
        this.command = command;
        this.executableClassName = executableClassName;
    }

    @Override
    public String getCommand() {
        return this.command;
    }

    @Override
    public String getHelpResource() {
        String helpResource = "/help/" + this.executableClassName.substring(this.executableClassName.lastIndexOf(46) + 1) + ".txt";
        return helpResource;
    }

    @Override
    public Executable newExecutable() throws SchemaCrawlerException {
        Executable executable;
        Class<?> commandExecutableClass;
        try {
            commandExecutableClass = Class.forName(this.executableClassName);
        }
        catch (ClassNotFoundException e) {
            throw new SchemaCrawlerException("Could not load class " + this.executableClassName, (Throwable)e);
        }
        try {
            executable = (Executable)commandExecutableClass.newInstance();
        }
        catch (Exception e) {
            LOGGER.log(Level.FINE, "Could not instantiate " + this.executableClassName + " using the default constructor");
            try {
                Constructor<?> constructor = commandExecutableClass.getConstructor(String.class);
                executable = (Executable)constructor.newInstance(this.command);
            }
            catch (Exception e1) {
                throw new SchemaCrawlerException("Could not instantiate executable for command '" + this.command + "'", (Throwable)e1);
            }
        }
        return executable;
    }

    public String toString() {
        return this.executableClassName;
    }
}

