/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import schemacrawler.crawl.AbstractRetriever;
import schemacrawler.crawl.MetadataResultSet;
import schemacrawler.crawl.MutableColumn;
import schemacrawler.crawl.MutableDatabase;
import schemacrawler.crawl.MutableForeignKey;
import schemacrawler.crawl.MutableIndex;
import schemacrawler.crawl.MutableIndexColumn;
import schemacrawler.crawl.MutablePrimaryKey;
import schemacrawler.crawl.MutableSchema;
import schemacrawler.crawl.MutableTable;
import schemacrawler.crawl.MutableView;
import schemacrawler.crawl.NamedObjectList;
import schemacrawler.crawl.RetrieverConnection;
import schemacrawler.schema.ForeignKeyDeferrability;
import schemacrawler.schema.ForeignKeyUpdateRule;
import schemacrawler.schema.IndexColumnSortSequence;
import schemacrawler.schema.IndexType;
import schemacrawler.schema.TableType;
import schemacrawler.schemacrawler.InclusionRule;
import schemacrawler.schemacrawler.SchemaCrawlerSQLException;
import sf.util.Utility;

final class TableRetriever
extends AbstractRetriever {
    private static final Logger LOGGER = Logger.getLogger(TableRetriever.class.getName());

    TableRetriever(RetrieverConnection retrieverConnection, MutableDatabase database) throws SQLException {
        super(retrieverConnection, database);
    }

    void retrieveColumns(MutableTable table, InclusionRule columnInclusionRule) throws SQLException {
        MetadataResultSet results = null;
        try {
            results = new MetadataResultSet(this.getMetaData().getColumns(this.unquotedName(table.getSchema().getCatalogName()), this.unquotedName(table.getSchema().getSchemaName()), this.unquotedName(table.getName()), null));
            while (results.next()) {
                String defaultValue = results.getString("COLUMN_DEF");
                String columnCatalogName = this.quotedName(results.getString("TABLE_CAT"));
                String schemaName = this.quotedName(results.getString("TABLE_SCHEM"));
                String tableName = this.quotedName(results.getString("TABLE_NAME"));
                String columnName = this.quotedName(results.getString("COLUMN_NAME"));
                LOGGER.log(Level.FINER, String.format("Retrieving column: %s.%s", tableName, columnName));
                MutableColumn column = this.lookupOrCreateColumn(table, columnName, false);
                String columnFullName = column.getFullName();
                if (!columnInclusionRule.include(columnFullName) || !table.getName().equals(tableName) || !this.belongsToSchema(table, columnCatalogName, schemaName)) continue;
                column = this.lookupOrCreateColumn(table, columnName, true);
                int ordinalPosition = results.getInt("ORDINAL_POSITION", 0);
                int dataType = results.getInt("DATA_TYPE", 0);
                String typeName = results.getString("TYPE_NAME");
                int size = results.getInt("COLUMN_SIZE", 0);
                int decimalDigits = results.getInt("DECIMAL_DIGITS", 0);
                boolean isNullable = results.getInt("NULLABLE", 2) == 1;
                String remarks = results.getString("REMARKS");
                column.setOrdinalPosition(ordinalPosition);
                column.setType(this.lookupOrCreateColumnDataType((MutableSchema)table.getSchema(), dataType, typeName));
                column.setSize(size);
                column.setDecimalDigits(decimalDigits);
                column.setRemarks(remarks);
                column.setNullable(isNullable);
                if (defaultValue != null) {
                    column.setDefaultValue(defaultValue);
                }
                column.addAttributes(results.getAttributes());
                table.addColumn(column);
            }
        }
        catch (SQLException e) {
            throw new SchemaCrawlerSQLException("Could not retrieve columns for table " + table, e);
        }
        finally {
            if (results != null) {
                results.close();
            }
        }
    }

    void retrieveForeignKeys(MutableTable table) throws SQLException {
        NamedObjectList<MutableForeignKey> foreignKeys = new NamedObjectList<MutableForeignKey>();
        DatabaseMetaData metaData = this.getMetaData();
        try {
            MetadataResultSet results = new MetadataResultSet(metaData.getImportedKeys(this.unquotedName(table.getSchema().getCatalogName()), this.unquotedName(table.getSchema().getSchemaName()), this.unquotedName(table.getName())));
            this.createForeignKeys(results, foreignKeys);
            results = new MetadataResultSet(metaData.getExportedKeys(this.unquotedName(table.getSchema().getCatalogName()), this.unquotedName(table.getSchema().getSchemaName()), this.unquotedName(table.getName())));
            this.createForeignKeys(results, foreignKeys);
        }
        catch (SQLException e) {
            throw new SchemaCrawlerSQLException("Could not retrieve forign keys for table " + table, e);
        }
    }

    void retrieveIndices(MutableTable table, boolean unique) throws SQLException {
        SQLException sqlEx = null;
        try {
            this.retrieveIndices1(table, unique);
        }
        catch (SQLException e) {
            sqlEx = e;
        }
        if (sqlEx != null) {
            try {
                sqlEx = null;
                this.retrieveIndices2(table, unique);
            }
            catch (SQLException e) {
                sqlEx = e;
            }
        }
        if (sqlEx != null) {
            throw sqlEx;
        }
    }

    void retrievePrimaryKey(MutableTable table) throws SQLException {
        MetadataResultSet results = null;
        try {
            results = new MetadataResultSet(this.getMetaData().getPrimaryKeys(this.unquotedName(table.getSchema().getCatalogName()), this.unquotedName(table.getSchema().getSchemaName()), this.unquotedName(table.getName())));
            while (results.next()) {
                MutableColumn column;
                String columnName = this.quotedName(results.getString("COLUMN_NAME"));
                String primaryKeyName = this.quotedName(results.getString("PK_NAME"));
                int keySequence = Integer.parseInt(results.getString("KEY_SEQ"));
                MutablePrimaryKey primaryKey = table.getPrimaryKey();
                if (primaryKey == null) {
                    primaryKey = new MutablePrimaryKey(table, primaryKeyName);
                }
                if ((column = table.getColumn(columnName)) != null) {
                    column.setPartOfPrimaryKey(true);
                    MutableIndexColumn indexColumn = new MutableIndexColumn(primaryKey, column);
                    indexColumn.setSortSequence(IndexColumnSortSequence.ascending);
                    indexColumn.setIndexOrdinalPosition(keySequence);
                    primaryKey.addColumn(indexColumn);
                }
                table.setPrimaryKey(primaryKey);
            }
        }
        catch (SQLException e) {
            throw new SchemaCrawlerSQLException("Could not retrieve primary keys for table " + table, e);
        }
        finally {
            if (results != null) {
                results.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void retrieveTables(String catalogName, String schemaName, String tableNamePattern, TableType[] tableTypes, InclusionRule tableInclusionRule) throws SQLException {
        if (tableInclusionRule == null || tableInclusionRule.equals(InclusionRule.EXCLUDE_ALL)) {
            return;
        }
        MetadataResultSet results = null;
        try {
            results = new MetadataResultSet(this.getMetaData().getTables(this.unquotedName(catalogName), this.unquotedName(schemaName), tableNamePattern, TableType.toStrings(tableTypes)));
            while (results.next()) {
                String tableName = this.quotedName(results.getString("TABLE_NAME"));
                LOGGER.log(Level.FINER, String.format("Retrieving table: %s.%s", schemaName, tableName));
                TableType tableType = results.getEnum("TABLE_TYPE", TableType.unknown);
                String remarks = results.getString("REMARKS");
                MutableSchema schema = this.lookupSchema(catalogName, schemaName);
                if (schema == null) {
                    LOGGER.log(Level.FINE, String.format("Cannot find schema, %s.%s", catalogName, schemaName));
                    continue;
                }
                MutableTable table = tableType == TableType.view ? new MutableView(schema, tableName) : new MutableTable(schema, tableName);
                if (!tableInclusionRule.include(table.getFullName())) continue;
                table.setType(tableType);
                table.setRemarks(remarks);
                schema.addTable(table);
            }
        }
        finally {
            if (results != null) {
                results.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createForeignKeys(MetadataResultSet results, NamedObjectList<MutableForeignKey> foreignKeys) throws SQLException {
        try {
            while (results.next()) {
                String foreignKeyName = this.quotedName(results.getString("FK_NAME"));
                if (Utility.isBlank(foreignKeyName)) {
                    foreignKeyName = "<unknown>";
                }
                LOGGER.log(Level.FINER, "Retrieving foreign key: " + foreignKeyName);
                String pkTableCatalogName = this.quotedName(results.getString("PKTABLE_CAT"));
                String pkTableSchemaName = this.quotedName(results.getString("PKTABLE_SCHEM"));
                String pkTableName = this.quotedName(results.getString("PKTABLE_NAME"));
                String pkColumnName = this.quotedName(results.getString("PKCOLUMN_NAME"));
                String fkTableCatalogName = this.quotedName(results.getString("FKTABLE_CAT"));
                String fkTableSchemaName = this.quotedName(results.getString("FKTABLE_SCHEM"));
                String fkTableName = this.quotedName(results.getString("FKTABLE_NAME"));
                String fkColumnName = this.quotedName(results.getString("FKCOLUMN_NAME"));
                MutableForeignKey foreignKey = foreignKeys.lookup(foreignKeyName);
                if (foreignKey == null) {
                    foreignKey = new MutableForeignKey(foreignKeyName);
                    foreignKeys.add(foreignKey);
                }
                int keySequence = results.getInt("KEY_SEQ", 0);
                int updateRule = results.getInt("UPDATE_RULE", ForeignKeyUpdateRule.unknown.getId());
                int deleteRule = results.getInt("DELETE_RULE", ForeignKeyUpdateRule.unknown.getId());
                int deferrability = results.getInt("DEFERRABILITY", ForeignKeyDeferrability.unknown.getId());
                MutableColumn pkColumn = this.lookupOrCreateColumn(pkTableCatalogName, pkTableSchemaName, pkTableName, pkColumnName);
                MutableColumn fkColumn = this.lookupOrCreateColumn(fkTableCatalogName, fkTableSchemaName, fkTableName, fkColumnName);
                if (pkColumn == null || fkColumn == null) continue;
                foreignKey.addColumnPair(keySequence, pkColumn, fkColumn);
                foreignKey.setUpdateRule(ForeignKeyUpdateRule.valueOf(updateRule));
                foreignKey.setDeleteRule(ForeignKeyUpdateRule.valueOf(deleteRule));
                foreignKey.setDeferrability(ForeignKeyDeferrability.valueOf(deferrability));
                foreignKey.addAttributes(results.getAttributes());
                fkColumn.setReferencedColumn(pkColumn);
                ((MutableTable)pkColumn.getParent()).addForeignKey(foreignKey);
                ((MutableTable)fkColumn.getParent()).addForeignKey(foreignKey);
            }
        }
        finally {
            results.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createIndices(MutableTable table, MetadataResultSet results) throws SQLException {
        try {
            while (results.next()) {
                String indexName = this.quotedName(results.getString("INDEX_NAME"));
                if (Utility.isBlank(indexName)) {
                    indexName = "<unknown>";
                }
                LOGGER.log(Level.FINER, String.format("Retrieving index: %s.%s", table.getFullName(), indexName));
                String columnName = this.quotedName(results.getString("COLUMN_NAME"));
                if (Utility.isBlank(columnName)) continue;
                MutableIndex index = table.getIndex(indexName);
                if (index == null) {
                    index = new MutableIndex(table, indexName);
                    table.addIndex(index);
                }
                boolean uniqueIndex = !results.getBoolean("NON_UNIQUE");
                int type = results.getInt("TYPE", IndexType.unknown.getId());
                int ordinalPosition = results.getInt("ORDINAL_POSITION", 0);
                IndexColumnSortSequence sortSequence = IndexColumnSortSequence.valueOfFromCode(results.getString("ASC_OR_DESC"));
                int cardinality = results.getInt("CARDINALITY", 0);
                int pages = results.getInt("PAGES", 0);
                MutableColumn column = table.getColumn(columnName);
                if (column == null) continue;
                column.setPartOfUniqueIndex(uniqueIndex);
                MutableIndexColumn indexColumn = new MutableIndexColumn(index, column);
                indexColumn.setIndexOrdinalPosition(ordinalPosition);
                indexColumn.setSortSequence(sortSequence);
                index.addColumn(indexColumn);
                index.setUnique(uniqueIndex);
                index.setType(IndexType.valueOf(type));
                index.setCardinality(cardinality);
                index.setPages(pages);
                index.addAttributes(results.getAttributes());
            }
        }
        finally {
            results.close();
        }
    }

    private MutableColumn lookupOrCreateColumn(MutableTable table, String columnName, boolean add) {
        MutableColumn column = null;
        if (table != null) {
            column = table.getColumn(columnName);
        }
        if (column == null) {
            column = new MutableColumn(table, columnName);
            if (add) {
                LOGGER.log(Level.FINER, String.format("Adding column to table: %s", column.getFullName()));
                table.addColumn(column);
            }
        }
        return column;
    }

    private MutableColumn lookupOrCreateColumn(String catalogName, String schemaName, String tableName, String columnName) {
        boolean supportsCatalogs = this.getRetrieverConnection().getDatabaseSystemParameters().isSupportsCatalogs();
        MutableColumn column = null;
        MutableSchema schema = this.lookupSchema(supportsCatalogs ? catalogName : null, schemaName);
        if (schema != null) {
            MutableTable table = schema.getTable(tableName);
            if (table != null) {
                column = table.getColumn(columnName);
            }
            if (column == null) {
                table = new MutableTable(schema, tableName);
                column = new MutableColumn(table, columnName);
                table.addColumn(column);
                LOGGER.log(Level.FINER, String.format("Creating new column that is referenced by a foreign key: %s", column.getFullName()));
            }
        }
        return column;
    }

    private void retrieveIndices1(MutableTable table, boolean unique) throws SQLException {
        MetadataResultSet results = null;
        try {
            results = new MetadataResultSet(this.getMetaData().getIndexInfo(this.unquotedName(table.getSchema().getCatalogName()), this.unquotedName(table.getSchema().getSchemaName()), this.unquotedName(table.getName()), unique, true));
            this.createIndices(table, results);
        }
        catch (SQLException e) {
            throw new SchemaCrawlerSQLException("Could not retrieve indices for table " + table, e);
        }
        finally {
            if (results != null) {
                results.close();
            }
        }
    }

    private void retrieveIndices2(MutableTable table, boolean unique) throws SQLException {
        MetadataResultSet results = null;
        try {
            results = new MetadataResultSet(this.getMetaData().getIndexInfo(null, null, table.getName(), unique, true));
            this.createIndices(table, results);
        }
        catch (SQLException e) {
            throw new SchemaCrawlerSQLException("Could not retrieve indices for table " + table, e);
        }
        finally {
            if (results != null) {
                results.close();
            }
        }
    }
}

