/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.util.Collection;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import schemacrawler.crawl.MutableProcedure;
import schemacrawler.crawl.MutableSchema;
import schemacrawler.crawl.NamedObjectList;
import schemacrawler.schema.Procedure;
import schemacrawler.schema.ProcedureColumn;
import schemacrawler.schemacrawler.InclusionRule;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;

class ProcedureFilter {
    private static final Logger LOGGER = Logger.getLogger(ProcedureFilter.class.getName());
    private final SchemaCrawlerOptions options;
    private final NamedObjectList<MutableProcedure> allProcedures;

    public ProcedureFilter(SchemaCrawlerOptions options, NamedObjectList<MutableProcedure> allProcedures) {
        this.options = options;
        this.allProcedures = allProcedures;
    }

    public void filter() {
        Collection<MutableProcedure> filteredProcedures = this.doFilter();
        for (MutableProcedure procedure : this.allProcedures) {
            if (filteredProcedures.contains(procedure)) continue;
            ((MutableSchema)procedure.getSchema()).removeProcedure(procedure);
            this.allProcedures.remove(procedure);
        }
    }

    private Collection<MutableProcedure> doFilter() {
        HashSet<MutableProcedure> greppedProcedures = new HashSet<MutableProcedure>();
        for (MutableProcedure procedure : this.allProcedures) {
            if (!this.grepMatch(this.options, procedure)) continue;
            greppedProcedures.add(procedure);
        }
        return greppedProcedures;
    }

    private boolean grepMatch(SchemaCrawlerOptions options, Procedure procedure) {
        boolean include;
        ProcedureColumn[] columns;
        boolean invertMatch = options.isGrepInvertMatch();
        boolean checkIncludeForColumns = options.isGrepProcedureColumns();
        boolean checkIncludeForDefinitions = options.isGrepDefinitions();
        InclusionRule grepProcedureColumnInclusionRule = options.getGrepProcedureColumnInclusionRule();
        InclusionRule grepDefinitionInclusionRule = options.getGrepDefinitionInclusionRule();
        if (!checkIncludeForColumns && !checkIncludeForDefinitions) {
            return true;
        }
        boolean includeForColumns = false;
        boolean includeForDefinitions = false;
        for (ProcedureColumn column : columns = procedure.getColumns()) {
            if (!checkIncludeForColumns || !grepProcedureColumnInclusionRule.include(column.getFullName())) continue;
            includeForColumns = true;
            break;
        }
        if (checkIncludeForDefinitions) {
            if (grepDefinitionInclusionRule.include(procedure.getRemarks())) {
                includeForDefinitions = true;
            }
            if (grepDefinitionInclusionRule.include(procedure.getDefinition())) {
                includeForDefinitions = true;
            }
        }
        boolean bl = include = includeForColumns || includeForDefinitions;
        if (invertMatch) {
            boolean bl2 = include = !include;
        }
        if (!include) {
            LOGGER.log(Level.FINE, "Removing procedure " + procedure + " since it does not match the grep pattern");
        }
        return include;
    }
}

