/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.text.base;

import java.util.logging.Logger;
import schemacrawler.schema.DatabaseInfo;
import schemacrawler.schema.JdbcDriverInfo;
import schemacrawler.schema.SchemaCrawlerInfo;
import schemacrawler.schemacrawler.SchemaCrawlerException;
import schemacrawler.tools.options.OutputOptions;
import schemacrawler.tools.text.base.BaseFormatter;
import schemacrawler.tools.text.base.BaseTextOptions;
import sf.util.Utility;

public abstract class BaseDotFormatter<O extends BaseTextOptions>
extends BaseFormatter<O> {
    protected static final Logger LOGGER = Logger.getLogger(BaseDotFormatter.class.getName());

    protected BaseDotFormatter(O options, boolean printVerboseDatabaseInfo, OutputOptions outputOptions) throws SchemaCrawlerException {
        super(options, printVerboseDatabaseInfo, outputOptions);
    }

    @Override
    public void begin() {
        String text = Utility.readResourceFully((String)"/dot.header.txt");
        this.out.println(text);
    }

    @Override
    public void end() {
        this.out.println("}");
        this.out.flush();
        this.out.close();
    }

    @Override
    public void handle(DatabaseInfo dbInfo) {
        if (this.options.isNoInfo() || dbInfo == null) {
            return;
        }
        this.out.append("        <tr>").append(Utility.NEWLINE);
        this.out.append("          <td align=\"right\">Database:</td>").append(Utility.NEWLINE);
        this.out.append("          <td align=\"left\">").append(dbInfo.getProductName()).append("  ").append(dbInfo.getProductVersion()).append("</td>").append(Utility.NEWLINE);
        this.out.append("        </tr>").append(Utility.NEWLINE);
    }

    @Override
    public void handle(JdbcDriverInfo driverInfo) {
        if (this.options.isNoInfo() || driverInfo == null) {
            return;
        }
        this.out.append("        <tr>").append(Utility.NEWLINE);
        this.out.append("          <td align=\"right\">JDBC Connection:</td>").append(Utility.NEWLINE);
        this.out.append("          <td align=\"left\">").append(driverInfo.getConnectionUrl()).append("</td>").append(Utility.NEWLINE);
        this.out.append("        </tr>").append(Utility.NEWLINE);
        this.out.append("        <tr>").append(Utility.NEWLINE);
        this.out.append("          <td align=\"right\">JDBC Driver:</td>").append(Utility.NEWLINE);
        this.out.append("          <td align=\"left\">").append(driverInfo.getDriverName()).append("  ").append(driverInfo.getDriverVersion()).append("</td>").append(Utility.NEWLINE);
        this.out.append("        </tr>").append(Utility.NEWLINE);
    }

    @Override
    public void handle(SchemaCrawlerInfo schemaCrawlerInfo) {
        if (this.options.isNoInfo() || schemaCrawlerInfo == null) {
            return;
        }
        this.out.append("        <tr>").append(Utility.NEWLINE);
        this.out.append("          <td align=\"right\">Generated by:</td>").append(Utility.NEWLINE);
        this.out.append("          <td align=\"left\">").append(schemaCrawlerInfo.getSchemaCrawlerProductName()).append(" ").append(schemaCrawlerInfo.getSchemaCrawlerVersion()).append("</td>").append(Utility.NEWLINE);
        this.out.append("        </tr>").append(Utility.NEWLINE);
    }

    @Override
    public void handleInfoEnd() throws SchemaCrawlerException {
        if (this.options.isNoInfo()) {
            return;
        }
        this.out.append("      </table>    >").append(Utility.NEWLINE).append("    labeljust=r").append(Utility.NEWLINE).append("    labelloc=b").append(Utility.NEWLINE).append("  ];").append(Utility.NEWLINE).append(Utility.NEWLINE);
    }

    @Override
    public void handleInfoStart() throws SchemaCrawlerException {
        if (this.options.isNoInfo()) {
            return;
        }
        this.out.append("  graph [fontcolor=\"#555555\", ").append(Utility.NEWLINE).append("    label=<").append(Utility.NEWLINE).append("<table color=\"#555555\" border=\"1\" cellborder=\"0\" cellspacing=\"0\">").append(Utility.NEWLINE);
    }
}

