/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.analysis.associations;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.SortedSet;
import java.util.TreeSet;
import schemacrawler.schema.ColumnReference;
import schemacrawler.schema.Database;
import schemacrawler.schema.Table;
import schemacrawler.schemacrawler.BaseDatabaseDecorator;
import schemacrawler.tools.analysis.associations.WeakAssociationsAnalyzer;

public final class DatabaseWithAssociations
extends BaseDatabaseDecorator {
    private static final long serialVersionUID = -3953296149824921463L;
    private static final String WEAK_ASSOCIATIONS_KEY = "schemacrawler.weak_associations";
    private final Collection<ColumnReference> weakAssociations;

    public static final Collection<ColumnReference> getWeakAssociations(Table table) {
        if (table == null) {
            return null;
        }
        SortedSet weakAssociations = (SortedSet)table.getAttribute(WEAK_ASSOCIATIONS_KEY, new TreeSet());
        ArrayList<ColumnReference> weakAssociationsList = new ArrayList<ColumnReference>(weakAssociations);
        Collections.sort(weakAssociationsList);
        return weakAssociationsList;
    }

    static void addWeakAssociationToTable(Table table, ColumnReference weakAssociation) {
        if (table != null && weakAssociation != null) {
            SortedSet tableWeakAssociations = (SortedSet)table.getAttribute(WEAK_ASSOCIATIONS_KEY, new TreeSet());
            tableWeakAssociations.add(weakAssociation);
            table.setAttribute(WEAK_ASSOCIATIONS_KEY, (Object)tableWeakAssociations);
        }
    }

    public DatabaseWithAssociations(Database database) {
        super(database);
        ArrayList<Table> allTables = new ArrayList<Table>(database.getTables());
        WeakAssociationsAnalyzer weakAssociationsAnalyzer = new WeakAssociationsAnalyzer(allTables);
        this.weakAssociations = weakAssociationsAnalyzer.analyzeTables();
    }

    public Collection<ColumnReference> getWeakAssociations() {
        return this.weakAssociations;
    }
}

