/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.text.operation;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Level;
import java.util.logging.Logger;
import schemacrawler.schema.DatabaseInfo;
import schemacrawler.schema.JdbcDriverInfo;
import schemacrawler.schema.SchemaCrawlerInfo;
import schemacrawler.schema.Table;
import schemacrawler.schemacrawler.SchemaCrawlerException;
import schemacrawler.tools.options.OutputFormat;
import schemacrawler.tools.options.OutputOptions;
import schemacrawler.tools.text.operation.DataJsonFormatter;
import schemacrawler.tools.text.operation.DataTextFormatter;
import schemacrawler.tools.text.operation.Operation;
import schemacrawler.tools.text.operation.OperationOptions;
import schemacrawler.tools.text.operation.Query;
import schemacrawler.tools.traversal.DataTraversalHandler;

final class OperationHandler {
    private static final Logger LOGGER = Logger.getLogger(OperationHandler.class.getName());
    private final Connection connection;
    private final DataTraversalHandler dataFormatter;
    private final Query query;

    OperationHandler(Operation operation, Query query, OperationOptions options, OutputOptions outputOptions, Connection connection) throws SchemaCrawlerException {
        if (connection == null) {
            throw new SchemaCrawlerException("No connection provided");
        }
        this.connection = connection;
        if (query == null) {
            throw new SchemaCrawlerException("No query provided");
        }
        this.query = query;
        if (options == null) {
            throw new SchemaCrawlerException("No operation options provided");
        }
        OutputFormat outputFormat = outputOptions.getOutputFormat();
        this.dataFormatter = outputFormat == OutputFormat.json ? new DataJsonFormatter(operation, options, outputOptions) : new DataTextFormatter(operation, options, outputOptions);
    }

    public void handle(SchemaCrawlerInfo schemaCrawlerInfo, DatabaseInfo databaseInfo, JdbcDriverInfo jdbcDriverInfo) throws SchemaCrawlerException {
        this.dataFormatter.handleInfoStart();
        this.dataFormatter.handle(schemaCrawlerInfo);
        this.dataFormatter.handle(databaseInfo);
        this.dataFormatter.handle(jdbcDriverInfo);
        this.dataFormatter.handleInfoEnd();
    }

    void begin() throws SchemaCrawlerException {
        try {
            if (this.connection.isClosed()) {
                throw new SchemaCrawlerException("Connection is closed");
            }
        }
        catch (SQLException e) {
            throw new SchemaCrawlerException("Connection is closed", (Throwable)e);
        }
        this.dataFormatter.begin();
    }

    void end() throws SchemaCrawlerException {
        if (!this.query.isQueryOver()) {
            String title = this.query.getName();
            String sql = this.query.getQuery();
            this.executeSqlAndHandleData(title, sql);
        }
        this.dataFormatter.end();
    }

    void handle(Table table) throws SchemaCrawlerException {
        if (this.query.isQueryOver()) {
            String title = table.getFullName();
            String sql = this.query.getQueryForTable(table);
            this.executeSqlAndHandleData(title, sql);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeSqlAndHandleData(String title, String sql) throws SchemaCrawlerException {
        LOGGER.log(Level.FINE, String.format("Executing query for %s: %s", title, sql));
        Statement statement = null;
        ResultSet results = null;
        try {
            statement = this.connection.createStatement();
            boolean hasResults = statement.execute(sql);
            if (hasResults) {
                results = statement.getResultSet();
                this.dataFormatter.handleData(title, results);
            }
        }
        catch (SQLException e) {
            LOGGER.log(Level.WARNING, "Error executing: " + sql, e);
        }
        finally {
            try {
                if (results != null) {
                    results.close();
                }
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException e) {
                LOGGER.log(Level.WARNING, "Error releasing resources", e);
            }
        }
    }
}

