/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.schemacrawler;

import java.util.HashMap;
import java.util.Map;
import schemacrawler.schemacrawler.BaseDatabaseConnectionOptions;
import schemacrawler.schemacrawler.SchemaCrawlerException;
import sf.util.TemplatingUtility;
import sf.util.Utility;

public final class DatabaseConfigConnectionOptions
extends BaseDatabaseConnectionOptions {
    private static final long serialVersionUID = -8141436553988174836L;
    private static final String DRIVER = "driver";
    private static final String URL = "url";
    private static final String HOST = "host";
    private static final String PORT = "port";
    private static final String DATABASE = "database";
    private static final String USER = "user";
    private static final String PASSWORD = "password";
    private final Map<String, String> properties;

    public DatabaseConfigConnectionOptions(Map<String, String> properties) throws SchemaCrawlerException {
        if (properties == null) {
            throw new SchemaCrawlerException("No connection properties provided");
        }
        this.properties = new HashMap<String, String>(properties);
        DatabaseConfigConnectionOptions.loadJdbcDriver(properties.get(DRIVER));
        this.setUser(properties.get(USER));
        this.setPassword(properties.get(PASSWORD));
    }

    @Override
    public String getConnectionUrl() {
        HashMap<String, String> properties = new HashMap<String, String>(this.properties);
        TemplatingUtility.substituteVariables(properties);
        String connectionUrl = (String)properties.get(URL);
        if (!TemplatingUtility.extractTemplateVariables(connectionUrl).isEmpty()) {
            throw new IllegalArgumentException("Insufficient parameters for database connection URL");
        }
        return connectionUrl;
    }

    public String getDatabase() {
        return this.properties.get(DATABASE);
    }

    public String getHost() {
        return this.properties.get(HOST);
    }

    public int getPort() {
        try {
            return Integer.parseInt(this.properties.get(PORT));
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public void setDatabase(String database) {
        if (database != null) {
            this.properties.put(DATABASE, database);
        }
    }

    public void setHost(String host) {
        if (!Utility.isBlank(host)) {
            this.properties.put(HOST, host);
        }
    }

    public void setPort(int port) {
        if (port > 0) {
            this.properties.put(PORT, String.valueOf(port));
        }
    }
}

