/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.traversal;

import java.util.ArrayList;
import java.util.Arrays;
import schemacrawler.schema.ColumnDataType;
import schemacrawler.schema.Database;
import schemacrawler.schema.Procedure;
import schemacrawler.schema.Schema;
import schemacrawler.schema.Table;
import schemacrawler.schemacrawler.SchemaCrawlerException;
import schemacrawler.tools.traversal.SchemaTraversalHandler;

public class SchemaTraverser {
    private Database database;
    private SchemaTraversalHandler handler;

    public Database getDatabase() {
        return this.database;
    }

    public SchemaTraversalHandler getFormatter() {
        return this.handler;
    }

    public void setDatabase(Database database) {
        this.database = database;
    }

    public void setFormatter(SchemaTraversalHandler formatter) {
        this.handler = formatter;
    }

    public final void traverse() throws SchemaCrawlerException {
        if (this.database == null || this.handler == null) {
            throw new SchemaCrawlerException("Cannot traverse database");
        }
        this.handler.begin();
        this.handler.handleInfoStart();
        this.handler.handle(this.database.getSchemaCrawlerInfo());
        this.handler.handle(this.database.getDatabaseInfo());
        this.handler.handle(this.database.getJdbcDriverInfo());
        this.handler.handleInfoEnd();
        ArrayList<ColumnDataType> columnDataTypes = new ArrayList<ColumnDataType>();
        ArrayList<Table> tables = new ArrayList<Table>();
        ArrayList<Procedure> procedures = new ArrayList<Procedure>();
        columnDataTypes.addAll(Arrays.asList(this.database.getSystemColumnDataTypes()));
        for (Schema schema : this.database.getSchemas()) {
            columnDataTypes.addAll(Arrays.asList(schema.getColumnDataTypes()));
            tables.addAll(Arrays.asList(schema.getTables()));
            procedures.addAll(Arrays.asList(schema.getProcedures()));
        }
        if (!columnDataTypes.isEmpty()) {
            this.handler.handleColumnDataTypesStart();
            for (ColumnDataType columnDataType : columnDataTypes) {
                this.handler.handle(columnDataType);
            }
            this.handler.handleColumnDataTypesEnd();
        }
        if (!tables.isEmpty()) {
            this.handler.handleTablesStart();
            for (Table table : tables) {
                this.handler.handle(table);
            }
            this.handler.handleTablesEnd();
        }
        if (!procedures.isEmpty()) {
            this.handler.handleProceduresStart();
            for (Procedure procedure : procedures) {
                this.handler.handle(procedure);
            }
            this.handler.handleProceduresEnd();
        }
        this.handler.end();
    }
}

