/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.hsqldb.Database;
import org.hsqldb.HsqlException;
import org.hsqldb.Table;
import org.hsqldb.error.Error;
import org.hsqldb.lib.FileUtil;
import org.hsqldb.lib.HsqlByteArrayOutputStream;
import org.hsqldb.lib.IntKeyHashMap;
import org.hsqldb.persist.CachedObject;
import org.hsqldb.persist.DataFileBlockManager;
import org.hsqldb.persist.DataFileCache;
import org.hsqldb.persist.PersistentStore;
import org.hsqldb.persist.ScaledRAFile;
import org.hsqldb.persist.TextFileSettings;
import org.hsqldb.rowio.RowInputInterface;
import org.hsqldb.rowio.RowInputText;
import org.hsqldb.rowio.RowInputTextQuoted;
import org.hsqldb.rowio.RowOutputText;
import org.hsqldb.rowio.RowOutputTextQuoted;
import org.hsqldb.scriptio.ScriptWriterText;

public class TextCache
extends DataFileCache {
    TextFileSettings textFileSettings;
    protected String header;
    protected Table table;
    private IntKeyHashMap uncommittedCache;

    TextCache(Table table, String string) {
        super(table.database, string);
        this.table = table;
        this.uncommittedCache = new IntKeyHashMap();
    }

    @Override
    protected void initParams(Database database, String string) {
        this.database = database;
        this.fa = FileUtil.getFileUtil();
        this.textFileSettings = new TextFileSettings(database, string);
        this.dataFileName = this.textFileSettings.getFileName();
        if (this.dataFileName == null) {
            throw Error.error(301);
        }
        this.dataFileName = ((FileUtil)this.fa).canonicalOrAbsolutePath(this.dataFileName);
        this.maxCacheRows = this.textFileSettings.getMaxCacheRows();
        this.maxCacheBytes = this.textFileSettings.getMaxCacheBytes();
        this.maxDataFileSize = Integer.MAX_VALUE;
        this.cachedRowPadding = 1;
        this.cacheFileScale = 1;
    }

    @Override
    protected void initBuffers() {
        if (this.textFileSettings.isQuoted || this.textFileSettings.isAllQuoted) {
            this.rowIn = new RowInputTextQuoted(this.textFileSettings.fs, this.textFileSettings.vs, this.textFileSettings.lvs, this.textFileSettings.isAllQuoted);
            this.rowOut = new RowOutputTextQuoted(this.textFileSettings.fs, this.textFileSettings.vs, this.textFileSettings.lvs, this.textFileSettings.isAllQuoted, this.textFileSettings.stringEncoding);
        } else {
            this.rowIn = new RowInputText(this.textFileSettings.fs, this.textFileSettings.vs, this.textFileSettings.lvs, false);
            this.rowOut = new RowOutputText(this.textFileSettings.fs, this.textFileSettings.vs, this.textFileSettings.lvs, false, this.textFileSettings.stringEncoding);
        }
    }

    @Override
    public void open(boolean bl) {
        this.fileFreePosition = 0L;
        try {
            int n = this.database.getType() == "res:" ? 2 : 5;
            this.dataFile = ScaledRAFile.newScaledRAFile(this.database, this.dataFileName, bl, n);
            this.fileFreePosition = this.dataFile.length();
            if (this.fileFreePosition > Integer.MAX_VALUE) {
                throw Error.error(468);
            }
            this.initBuffers();
            this.freeBlocks = new DataFileBlockManager(0, this.cacheFileScale, 0, 0L);
        }
        catch (Throwable throwable) {
            throw Error.error(throwable, 452, 42, new Object[]{throwable.toString(), this.dataFileName});
        }
        this.cacheReadonly = bl;
    }

    void reopen() {
        this.open(this.cacheReadonly);
    }

    @Override
    public void close(boolean bl) {
        if (this.dataFile == null) {
            return;
        }
        this.writeLock.lock();
        try {
            this.cache.saveAll();
            boolean bl2 = this.dataFile.length() <= (long)TextFileSettings.NL.length();
            this.dataFile.synch();
            this.dataFile.close();
            this.dataFile = null;
            if (bl2 && !this.cacheReadonly) {
                FileUtil.getFileUtil().delete(this.dataFileName);
            }
            this.uncommittedCache.clear();
        }
        catch (Throwable throwable) {
            throw Error.error(throwable, 452, 43, new Object[]{throwable.toString(), this.dataFileName});
        }
        finally {
            this.writeLock.unlock();
        }
    }

    void purge() {
        this.writeLock.lock();
        try {
            this.uncommittedCache.clear();
            if (this.cacheReadonly) {
                this.close(false);
            } else {
                if (this.dataFile != null) {
                    this.dataFile.close();
                    this.dataFile = null;
                }
                FileUtil.getFileUtil().delete(this.dataFileName);
            }
        }
        catch (Throwable throwable) {
            throw Error.error(throwable, 452, 44, new Object[]{throwable.toString(), this.dataFileName});
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    int setFilePos(CachedObject cachedObject) {
        int n = cachedObject.getStorageSize();
        long l = this.fileFreePosition + (long)n;
        if (l > this.maxDataFileSize) {
            this.database.logger.logSevereEvent("data file reached maximum size " + this.dataFileName, null);
            throw Error.error(468);
        }
        int n2 = (int)this.fileFreePosition;
        cachedObject.setPos(n2);
        this.clearRowImage(cachedObject);
        this.fileFreePosition = l;
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(int n, PersistentStore persistentStore) {
        this.writeLock.lock();
        try {
            CachedObject cachedObject = (CachedObject)this.uncommittedCache.remove(n);
            if (cachedObject != null) {
                return;
            }
            cachedObject = this.cache.release(n);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removePersistence(int n, PersistentStore persistentStore) {
        this.writeLock.lock();
        try {
            CachedObject cachedObject = (CachedObject)this.uncommittedCache.remove(n);
            if (cachedObject == null && (cachedObject = this.get(n, persistentStore, false)) != null) {
                this.clearRowImage(cachedObject);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private void clearRowImage(CachedObject cachedObject) {
        try {
            int n = cachedObject.getStorageSize() - ScriptWriterText.BYTES_LINE_SEP.length;
            this.rowOut.reset();
            HsqlByteArrayOutputStream hsqlByteArrayOutputStream = this.rowOut.getOutputStream();
            hsqlByteArrayOutputStream.fill(32, n);
            hsqlByteArrayOutputStream.write(ScriptWriterText.BYTES_LINE_SEP);
            this.dataFile.seek(cachedObject.getPos());
            this.dataFile.write(hsqlByteArrayOutputStream.getBuffer(), 0, hsqlByteArrayOutputStream.size());
        }
        catch (IOException iOException) {
            throw Error.runtimeError(201, iOException.getMessage());
        }
    }

    @Override
    protected RowInputInterface readObject(int n) {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        HsqlByteArrayOutputStream hsqlByteArrayOutputStream = new HsqlByteArrayOutputStream(128);
        if ((n = this.findNextUsedLinePos(n)) == -1) {
            return null;
        }
        try {
            this.dataFile.seek(n);
            while (!bl2) {
                int n2 = this.dataFile.read();
                bl4 = false;
                if (n2 == -1) {
                    if (hsqlByteArrayOutputStream.size() == 0) {
                        return null;
                    }
                    bl2 = true;
                    if (bl3 || this.cacheReadonly) break;
                    this.dataFile.write(TextFileSettings.BYTES_LINE_SEP, 0, TextFileSettings.BYTES_LINE_SEP.length);
                    hsqlByteArrayOutputStream.write(TextFileSettings.BYTES_LINE_SEP);
                    break;
                }
                switch (n2) {
                    case 34: {
                        bl4 = true;
                        bl2 = bl3;
                        bl3 = false;
                        if (!this.textFileSettings.isQuoted) break;
                        bl = !bl;
                        break;
                    }
                    case 13: {
                        bl3 = !bl;
                        break;
                    }
                    case 10: {
                        bl2 = !bl;
                        break;
                    }
                    default: {
                        bl4 = true;
                        bl2 = bl3;
                        bl3 = false;
                    }
                }
                hsqlByteArrayOutputStream.write(n2);
            }
            if (bl2) {
                String string;
                if (bl4) {
                    hsqlByteArrayOutputStream.setPosition(hsqlByteArrayOutputStream.size() - 1);
                }
                try {
                    string = hsqlByteArrayOutputStream.toString(this.textFileSettings.stringEncoding);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    string = hsqlByteArrayOutputStream.toString();
                }
                ((RowInputText)this.rowIn).setSource(string, n, hsqlByteArrayOutputStream.size());
                return this.rowIn;
            }
            return null;
        }
        catch (IOException iOException) {
            throw Error.error(484, iOException);
        }
    }

    public int readHeaderLine() {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        HsqlByteArrayOutputStream hsqlByteArrayOutputStream = new HsqlByteArrayOutputStream(128);
        while (!bl) {
            int n;
            bl3 = false;
            try {
                n = this.dataFile.read();
                if (n == -1) {
                    if (hsqlByteArrayOutputStream.size() == 0) {
                        return 0;
                    }
                    bl = true;
                    if (this.cacheReadonly) break;
                    this.dataFile.write(TextFileSettings.BYTES_LINE_SEP, 0, TextFileSettings.BYTES_LINE_SEP.length);
                    hsqlByteArrayOutputStream.write(TextFileSettings.BYTES_LINE_SEP);
                    break;
                }
            }
            catch (IOException iOException) {
                throw Error.error(483);
            }
            switch (n) {
                case 13: {
                    bl2 = true;
                    break;
                }
                case 10: {
                    bl = true;
                    break;
                }
                default: {
                    bl3 = true;
                    bl = bl2;
                    bl2 = false;
                }
            }
            if (bl2 || bl) continue;
            hsqlByteArrayOutputStream.write(n);
        }
        if (bl3) {
            hsqlByteArrayOutputStream.setPosition(hsqlByteArrayOutputStream.size() - 1);
        }
        try {
            this.header = hsqlByteArrayOutputStream.toString(this.textFileSettings.stringEncoding);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this.header = hsqlByteArrayOutputStream.toString();
        }
        return hsqlByteArrayOutputStream.size();
    }

    private int findNextUsedLinePos(int n) {
        try {
            int n2 = n;
            int n3 = n;
            boolean bl = false;
            this.dataFile.seek(n);
            block8: while (true) {
                int n4 = this.dataFile.read();
                ++n3;
                switch (n4) {
                    case 13: {
                        bl = true;
                        continue block8;
                    }
                    case 10: {
                        bl = false;
                        ((RowInputText)this.rowIn).skippedLine();
                        n2 = n3;
                        continue block8;
                    }
                    case 32: {
                        if (!bl) continue block8;
                        bl = false;
                        ((RowInputText)this.rowIn).skippedLine();
                        continue block8;
                    }
                    case -1: {
                        return -1;
                    }
                }
                break;
            }
            if (bl) {
                bl = false;
                ((RowInputText)this.rowIn).skippedLine();
            }
            return n2;
        }
        catch (IOException iOException) {
            throw Error.error(484, iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(CachedObject cachedObject) {
        this.writeLock.lock();
        try {
            this.setFilePos(cachedObject);
            this.uncommittedCache.put(cachedObject.getPos(), cachedObject);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public CachedObject get(CachedObject cachedObject, PersistentStore persistentStore, boolean bl) {
        if (cachedObject == null) {
            return null;
        }
        return this.get(cachedObject.getPos(), persistentStore, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CachedObject get(int n, PersistentStore persistentStore, boolean bl) {
        CachedObject cachedObject;
        if (n < 0) {
            return null;
        }
        this.readLock.lock();
        try {
            cachedObject = (CachedObject)this.uncommittedCache.get(n);
            if (cachedObject != null) {
                CachedObject cachedObject2 = cachedObject;
                return cachedObject2;
            }
        }
        finally {
            this.readLock.unlock();
        }
        cachedObject = super.get(n, persistentStore, bl);
        return cachedObject;
    }

    @Override
    protected void saveRows(CachedObject[] cachedObjectArray, int n, int n2) {
        if (n2 == 0) {
            return;
        }
        for (int i = n; i < n + n2; ++i) {
            CachedObject cachedObject = cachedObjectArray[i];
            this.uncommittedCache.put(cachedObject.getPos(), cachedObject);
            cachedObjectArray[i] = null;
        }
    }

    @Override
    public void saveRow(CachedObject cachedObject) {
        this.writeLock.lock();
        try {
            this.setFileModified();
            this.saveRowNoLock(cachedObject);
            this.uncommittedCache.remove(cachedObject.getPos());
            this.cache.put(cachedObject.getPos(), cachedObject);
        }
        catch (Throwable throwable) {
            this.database.logger.logSevereEvent("saveRow failed", throwable);
            throw Error.error(466, throwable);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public String getHeader() {
        return this.header;
    }

    public void setHeaderInitialise(String string) {
        this.header = string;
    }

    public void setHeader(String string) {
        if (this.textFileSettings.ignoreFirst && this.fileFreePosition == 0L) {
            try {
                this.writeHeader(string);
                this.header = string;
            }
            catch (HsqlException hsqlException) {
                throw new HsqlException(hsqlException, Error.getMessage(467), 467);
            }
            return;
        }
        throw Error.error(486);
    }

    private void writeHeader(String string) {
        try {
            byte[] byArray = null;
            String string2 = string + TextFileSettings.NL;
            try {
                byArray = string2.getBytes(this.textFileSettings.stringEncoding);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                byArray = string2.getBytes();
            }
            this.dataFile.write(byArray, 0, byArray.length);
            this.fileFreePosition = byArray.length;
        }
        catch (IOException iOException) {
            throw Error.error(484, iOException);
        }
    }

    public int getLineNumber() {
        return ((RowInputText)this.rowIn).getLineNumber();
    }

    public TextFileSettings getTextFileSettings() {
        return this.textFileSettings;
    }

    public boolean isIgnoreFirstLine() {
        return this.textFileSettings.ignoreFirst;
    }

    @Override
    protected void setFileModified() {
        this.fileModified = true;
    }
}

