/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Expression;
import org.hsqldb.ExpressionColumn;
import org.hsqldb.ExpressionOp;
import org.hsqldb.ExpressionOrderBy;
import org.hsqldb.QuerySpecification;
import org.hsqldb.Session;
import org.hsqldb.Table;
import org.hsqldb.TableBase;
import org.hsqldb.error.Error;
import org.hsqldb.index.Index;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.types.Collation;
import org.hsqldb.types.Type;

public final class SortAndSlice {
    static final SortAndSlice noSort = new SortAndSlice();
    public int[] sortOrder;
    public boolean[] sortDescending;
    public boolean[] sortNullsLast;
    public Collation[] collations;
    boolean sortUnion;
    HsqlArrayList exprList = new HsqlArrayList();
    ExpressionOp limitCondition;
    int columnCount;
    boolean hasNullsLast;
    boolean strictLimit;
    boolean zeroLimit;
    public boolean skipSort = false;
    public boolean skipFullResult = false;
    public Index index;
    public boolean isGenerated;

    SortAndSlice() {
    }

    public HsqlArrayList getExpressionList() {
        return this.exprList;
    }

    public boolean hasOrder() {
        return this.exprList.size() != 0;
    }

    public boolean hasLimit() {
        return this.limitCondition != null;
    }

    public int getOrderLength() {
        return this.exprList.size();
    }

    public void addOrderExpression(Expression expression) {
        this.exprList.add(expression);
    }

    public void addLimitCondition(ExpressionOp expressionOp) {
        this.limitCondition = expressionOp;
    }

    public void setStrictLimit() {
        this.strictLimit = true;
    }

    public void setZeroLimit() {
        this.zeroLimit = true;
    }

    public void prepareSingleColumn(int n) {
        this.sortOrder = new int[1];
        this.sortDescending = new boolean[1];
        this.sortNullsLast = new boolean[1];
        this.sortOrder[0] = n;
    }

    public void prepare(int n) {
        this.columnCount = this.exprList.size();
        if (this.columnCount == 0) {
            return;
        }
        this.sortOrder = new int[this.columnCount + n];
        this.sortDescending = new boolean[this.columnCount + n];
        this.sortNullsLast = new boolean[this.columnCount + n];
        ArrayUtil.fillSequence(this.sortOrder);
        for (int i = 0; i < this.columnCount; ++i) {
            ExpressionOrderBy expressionOrderBy = (ExpressionOrderBy)this.exprList.get(i);
            this.sortDescending[i] = expressionOrderBy.isDescending();
            this.sortNullsLast[i] = expressionOrderBy.isNullsLast();
            this.hasNullsLast |= this.sortNullsLast[i];
        }
    }

    public void prepare(QuerySpecification querySpecification) {
        this.columnCount = this.exprList.size();
        if (this.columnCount == 0) {
            return;
        }
        this.sortOrder = new int[this.columnCount];
        this.sortDescending = new boolean[this.columnCount];
        this.sortNullsLast = new boolean[this.columnCount];
        for (int i = 0; i < this.columnCount; ++i) {
            ExpressionOrderBy expressionOrderBy = (ExpressionOrderBy)this.exprList.get(i);
            this.sortOrder[i] = expressionOrderBy.getLeftNode().queryTableColumnIndex == -1 ? querySpecification.indexStartOrderBy + i : expressionOrderBy.getLeftNode().queryTableColumnIndex;
            this.sortDescending[i] = expressionOrderBy.isDescending();
            this.sortNullsLast[i] = expressionOrderBy.isNullsLast();
            this.hasNullsLast |= this.sortNullsLast[i];
            if (expressionOrderBy.collation == null) continue;
            if (this.collations == null) {
                this.collations = new Collation[this.columnCount];
            }
            this.collations[i] = expressionOrderBy.collation;
        }
    }

    void setSortRange(QuerySpecification querySpecification) {
        boolean bl;
        Object object;
        if (this.isGenerated) {
            return;
        }
        for (int i = 0; i < this.columnCount; ++i) {
            ExpressionOrderBy expressionOrderBy = (ExpressionOrderBy)this.exprList.get(i);
            object = expressionOrderBy.getLeftNode().getDataType();
            if (!((Type)object).isArrayType() && !((Type)object).isLobType()) continue;
            throw Error.error(5534);
        }
        if (querySpecification.isDistinctSelect || querySpecification.isGrouped || querySpecification.isAggregated) {
            return;
        }
        if (this.columnCount == 0) {
            if (this.limitCondition == null) {
                return;
            }
            this.skipFullResult = true;
            return;
        }
        if (querySpecification == null || this.hasNullsLast) {
            return;
        }
        if (this.collations != null) {
            return;
        }
        int[] nArray = new int[this.columnCount];
        for (int i = 0; i < this.columnCount; ++i) {
            object = ((Expression)this.exprList.get(i)).getLeftNode();
            if (((Expression)object).getType() != 2) {
                return;
            }
            if (((ExpressionColumn)object).getRangeVariable() != querySpecification.rangeVariables[0]) {
                return;
            }
            nArray[i] = ((Expression)object).columnIndex;
        }
        Index index = querySpecification.rangeVariables[0].getSortIndex();
        if (index == null) {
            return;
        }
        object = nArray;
        nArray = index.getColumns();
        int n = ArrayUtil.countTrueElements(this.sortDescending);
        boolean bl2 = bl = n == this.columnCount;
        if (!bl && n > 0) {
            return;
        }
        if (nArray.length > 0) {
            if (ArrayUtil.haveEqualArrays((int[])object, nArray, ((Object)object).length)) {
                boolean bl3;
                if (bl && !(bl3 = querySpecification.rangeVariables[0].reverseOrder())) {
                    return;
                }
                this.skipSort = true;
                this.skipFullResult = true;
            }
        } else {
            Table table = querySpecification.rangeVariables[0].getTable();
            Index index2 = table.getFullIndexForColumns(nArray);
            if (index2 != null && querySpecification.rangeVariables[0].setSortIndex(index2, bl)) {
                this.skipSort = true;
                this.skipFullResult = true;
            }
        }
    }

    public boolean prepareSpecial(Session session, QuerySpecification querySpecification) {
        Expression expression = querySpecification.exprColumns[querySpecification.indexStartAggregates];
        int n = expression.getType();
        if ((expression = expression.getLeftNode()).getType() != 2) {
            return false;
        }
        if (((ExpressionColumn)expression).getRangeVariable() != querySpecification.rangeVariables[0]) {
            return false;
        }
        Index index = querySpecification.rangeVariables[0].getSortIndex();
        if (index == null) {
            return false;
        }
        if (querySpecification.rangeVariables[0].hasSingleIndexCondition()) {
            int[] nArray = index.getColumns();
            if (nArray[0] != ((ExpressionColumn)expression).getColumnIndex()) {
                return false;
            }
            if (n == 74) {
                querySpecification.rangeVariables[0].reverseOrder();
            }
        } else {
            if (querySpecification.rangeVariables[0].hasAnyIndexCondition()) {
                return false;
            }
            Table table = querySpecification.rangeVariables[0].getTable();
            Index index2 = table.getIndexForColumn(session, ((ExpressionColumn)expression).getColumnIndex());
            if (index2 == null) {
                return false;
            }
            if (!querySpecification.rangeVariables[0].setSortIndex(index2, n == 74)) {
                return false;
            }
        }
        this.columnCount = 1;
        this.sortOrder = new int[this.columnCount];
        this.sortDescending = new boolean[this.columnCount];
        this.sortNullsLast = new boolean[this.columnCount];
        this.skipSort = true;
        this.skipFullResult = true;
        return true;
    }

    public int getLimitStart(Session session) {
        Integer n;
        if (this.limitCondition != null && (n = (Integer)this.limitCondition.getLeftNode().getValue(session)) != null) {
            return n;
        }
        return 0;
    }

    public int getLimitCount(Session session, int n) {
        Integer n2;
        int n3 = 0;
        if (this.limitCondition != null && (n2 = (Integer)this.limitCondition.getRightNode().getValue(session)) != null) {
            n3 = n2;
        }
        if (n != 0 && (n3 == 0 || n < n3)) {
            n3 = n;
        }
        return n3;
    }

    public void setIndex(Session session, TableBase tableBase) {
        this.index = this.getNewIndex(session, tableBase);
    }

    public Index getNewIndex(Session session, TableBase tableBase) {
        if (this.hasOrder()) {
            Index index = tableBase.createAndAddIndexStructure(session, null, this.sortOrder, this.sortDescending, this.sortNullsLast, false, false, false);
            if (this.collations != null) {
                for (int i = 0; i < this.columnCount; ++i) {
                    if (this.collations[i] == null) continue;
                    Type type = index.getColumnTypes()[i];
                    index.getColumnTypes()[i] = type = Type.getType(type.typeCode, type.getCharacterSet(), this.collations[i], type.precision, type.scale);
                }
            }
            return index;
        }
        return null;
    }
}

