/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.io.IOException;
import org.hsqldb.RowAVL;
import org.hsqldb.TableBase;
import org.hsqldb.error.Error;
import org.hsqldb.index.NodeAVL;
import org.hsqldb.index.NodeAVLDisk;
import org.hsqldb.lib.IntLookup;
import org.hsqldb.persist.PersistentStore;
import org.hsqldb.rowio.RowInputInterface;
import org.hsqldb.rowio.RowOutputInterface;

public class RowAVLDisk
extends RowAVL {
    public static final int NO_POS = -1;
    int storageSize;
    int keepCount;
    volatile boolean isInMemory;
    int accessCount;
    private boolean hasDataChanged;
    private boolean hasNodesChanged;

    public RowAVLDisk(TableBase tableBase, Object[] objectArray, PersistentStore persistentStore) {
        super(tableBase, objectArray);
        this.setNewNodes(persistentStore);
        this.hasNodesChanged = true;
        this.hasDataChanged = true;
    }

    public RowAVLDisk(TableBase tableBase, RowInputInterface rowInputInterface) throws IOException {
        super(tableBase, null);
        this.position = rowInputInterface.getPos();
        this.storageSize = rowInputInterface.getSize();
        int n = tableBase.getIndexCount();
        NodeAVL nodeAVL = this.nPrimaryNode = new NodeAVLDisk(this, rowInputInterface, 0);
        for (int i = 1; i < n; ++i) {
            nodeAVL = nodeAVL.nNext = new NodeAVLDisk(this, rowInputInterface, i);
        }
        this.rowData = rowInputInterface.readData(this.table.getColumnTypes());
    }

    @Override
    public NodeAVL insertNode(int n) {
        return null;
    }

    private void readRowInfo(RowInputInterface rowInputInterface) throws IOException {
    }

    public synchronized void setNodesChanged() {
        this.hasNodesChanged = true;
    }

    @Override
    public void updateAccessCount(int n) {
        this.accessCount = n;
    }

    @Override
    public int getAccessCount() {
        return this.accessCount;
    }

    @Override
    public int getStorageSize() {
        return this.storageSize;
    }

    @Override
    public boolean isMemory() {
        return false;
    }

    @Override
    public void setPos(int n) {
        this.position = n;
        NodeAVL nodeAVL = this.nPrimaryNode;
        while (nodeAVL != null) {
            ((NodeAVLDisk)nodeAVL).iData = this.position;
            nodeAVL = nodeAVL.nNext;
        }
    }

    @Override
    public synchronized void setChanged(boolean bl) {
        this.hasDataChanged = bl;
    }

    @Override
    public synchronized boolean hasChanged() {
        return this.hasNodesChanged || this.hasDataChanged;
    }

    @Override
    public TableBase getTable() {
        return this.table;
    }

    @Override
    public void setStorageSize(int n) {
        this.storageSize = n;
    }

    @Override
    public synchronized boolean isKeepInMemory() {
        return this.keepCount > 0;
    }

    @Override
    public void delete(PersistentStore persistentStore) {
        RowAVLDisk rowAVLDisk = this;
        if (!rowAVLDisk.keepInMemory(true)) {
            rowAVLDisk = (RowAVLDisk)persistentStore.get(rowAVLDisk, true);
        }
        super.delete(persistentStore);
        rowAVLDisk.keepInMemory(false);
    }

    @Override
    public void destroy() {
        this.nPrimaryNode = null;
        this.table = null;
    }

    @Override
    public synchronized boolean keepInMemory(boolean bl) {
        if (!this.isInMemory) {
            return false;
        }
        if (bl) {
            ++this.keepCount;
        } else {
            --this.keepCount;
            if (this.keepCount < 0) {
                throw Error.runtimeError(201, "RowAVLDisk - keep count");
            }
        }
        return true;
    }

    @Override
    public synchronized boolean isInMemory() {
        return this.isInMemory;
    }

    @Override
    public synchronized void setInMemory(boolean bl) {
        this.isInMemory = bl;
        if (bl) {
            return;
        }
        NodeAVL nodeAVL = this.nPrimaryNode;
        while (nodeAVL != null) {
            nodeAVL.setInMemory(bl);
            nodeAVL = nodeAVL.nNext;
        }
    }

    @Override
    public void setNewNodes(PersistentStore persistentStore) {
        int n = persistentStore.getAccessorKeys().length;
        NodeAVL nodeAVL = this.nPrimaryNode = new NodeAVLDisk(this, 0);
        for (int i = 1; i < n; ++i) {
            nodeAVL = nodeAVL.nNext = new NodeAVLDisk(this, i);
        }
    }

    @Override
    public int getRealSize(RowOutputInterface rowOutputInterface) {
        return rowOutputInterface.getSize(this);
    }

    @Override
    public void write(RowOutputInterface rowOutputInterface) {
        try {
            this.writeNodes(rowOutputInterface);
            if (this.hasDataChanged) {
                rowOutputInterface.writeData(this, this.table.colTypes);
                rowOutputInterface.writeEnd();
                this.hasDataChanged = false;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void write(RowOutputInterface rowOutputInterface, IntLookup intLookup) {
        rowOutputInterface.writeSize(this.storageSize);
        NodeAVL nodeAVL = this.nPrimaryNode;
        while (nodeAVL != null) {
            ((NodeAVLDisk)nodeAVL).write(rowOutputInterface, intLookup);
            nodeAVL = nodeAVL.nNext;
        }
        rowOutputInterface.writeData(this, this.table.colTypes);
        rowOutputInterface.writeEnd();
    }

    private void writeNodes(RowOutputInterface rowOutputInterface) throws IOException {
        rowOutputInterface.writeSize(this.storageSize);
        NodeAVL nodeAVL = this.nPrimaryNode;
        while (nodeAVL != null) {
            nodeAVL.write(rowOutputInterface);
            nodeAVL = nodeAVL.nNext;
        }
        this.hasNodesChanged = false;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof RowAVLDisk) {
            return ((RowAVLDisk)object).position == this.position;
        }
        return false;
    }
}

