/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.ColumnSchema;
import org.hsqldb.Expression;
import org.hsqldb.ExpressionColumn;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.ParserDQL;
import org.hsqldb.QuerySpecification;
import org.hsqldb.RangeVariable;
import org.hsqldb.Session;
import org.hsqldb.Table;
import org.hsqldb.error.Error;
import org.hsqldb.index.Index;
import org.hsqldb.lib.HashSet;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.store.ValuePool;

public class RangeVariableJoined
extends RangeVariable {
    RangeVariable[] rangeArray;

    RangeVariableJoined(Table table, HsqlNameManager.SimpleName simpleName, OrderedHashSet orderedHashSet, HsqlNameManager.SimpleName[] simpleNameArray, ParserDQL.CompileContext compileContext) {
        super(table, simpleName, orderedHashSet, simpleNameArray, compileContext);
        QuerySpecification querySpecification = (QuerySpecification)this.rangeTable.getQueryExpression();
        this.rangeArray = querySpecification.rangeVariables;
    }

    @Override
    public void setRangeTableVariables() {
        super.setRangeTableVariables();
    }

    @Override
    public RangeVariable duplicate() {
        RangeVariable rangeVariable = null;
        try {
            rangeVariable = (RangeVariable)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw Error.runtimeError(201, "RangeVariable");
        }
        rangeVariable.resetConditions();
        return rangeVariable;
    }

    @Override
    void setJoinType(boolean bl, boolean bl2) {
        super.setJoinType(bl, bl2);
    }

    @Override
    public void addNamedJoinColumns(OrderedHashSet orderedHashSet) {
        super.addNamedJoinColumns(orderedHashSet);
    }

    @Override
    public void addColumn(int n) {
        super.addColumn(n);
    }

    @Override
    public void addAllColumns() {
        super.addAllColumns();
    }

    @Override
    void addNamedJoinColumnExpression(String string, Expression expression) {
        super.addNamedJoinColumnExpression(string, expression);
    }

    @Override
    ExpressionColumn getColumnExpression(String string) {
        return super.getColumnExpression(string);
    }

    @Override
    Table getTable() {
        return super.getTable();
    }

    @Override
    boolean hasSingleIndexCondition() {
        return super.hasSingleIndexCondition();
    }

    @Override
    boolean setDistinctColumnsOnIndex(int[] nArray) {
        return super.setDistinctColumnsOnIndex(nArray);
    }

    @Override
    Index getSortIndex() {
        return super.getSortIndex();
    }

    @Override
    boolean setSortIndex(Index index, boolean bl) {
        return super.setSortIndex(index, bl);
    }

    @Override
    boolean reverseOrder() {
        return super.reverseOrder();
    }

    @Override
    public OrderedHashSet getColumnNames() {
        return super.getColumnNames();
    }

    @Override
    public OrderedHashSet getUniqueColumnNameSet() {
        return super.getUniqueColumnNameSet();
    }

    @Override
    public int findColumn(ExpressionColumn expressionColumn) {
        if (this.tableAlias != null) {
            return super.findColumn(expressionColumn);
        }
        int n = 0;
        for (int i = 0; i < this.rangeArray.length; ++i) {
            int n2 = this.rangeArray[i].findColumn(expressionColumn);
            if (n2 > -1) {
                return n + n2;
            }
            n += this.rangeArray[i].rangeTable.getColumnCount();
        }
        return -1;
    }

    @Override
    public int findColumn(String string) {
        return super.findColumn(string);
    }

    @Override
    ColumnSchema getColumn(String string) {
        return super.getColumn(string);
    }

    @Override
    ColumnSchema getColumn(int n) {
        return super.getColumn(n);
    }

    @Override
    String getColumnAlias(int n) {
        return super.getColumnAlias(n);
    }

    @Override
    public HsqlNameManager.SimpleName getColumnAliasName(int n) {
        return super.getColumnAliasName(n);
    }

    @Override
    boolean hasColumnAlias() {
        return super.hasColumnAlias();
    }

    @Override
    String getTableAlias() {
        return super.getTableAlias();
    }

    @Override
    HsqlNameManager.SimpleName getTableAliasName() {
        return super.getTableAliasName();
    }

    @Override
    boolean resolvesTableName(ExpressionColumn expressionColumn) {
        if (this.tableAlias != null) {
            return super.resolvesTableName(expressionColumn);
        }
        for (int i = 0; i < this.rangeArray.length; ++i) {
            if (!this.rangeArray[i].resolvesTableName(expressionColumn)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean resolvesTableName(String string) {
        if (this.tableAlias != null) {
            return super.resolvesTableName(string);
        }
        for (int i = 0; i < this.rangeArray.length; ++i) {
            if (!this.rangeArray[i].resolvesTableName(string)) continue;
            return true;
        }
        return false;
    }

    @Override
    boolean resolvesSchemaName(String string) {
        return super.resolvesSchemaName(string);
    }

    @Override
    void addTableColumns(HsqlArrayList hsqlArrayList) {
        super.addTableColumns(hsqlArrayList);
    }

    @Override
    int addTableColumns(HsqlArrayList hsqlArrayList, int n, HashSet hashSet) {
        return super.addTableColumns(hsqlArrayList, n, hashSet);
    }

    @Override
    void addTableColumns(Expression expression, HashSet hashSet) {
        super.addTableColumns(expression, hashSet);
    }

    @Override
    void setForCheckConstraint() {
        super.setForCheckConstraint();
    }

    @Override
    Expression getJoinCondition() {
        return super.getJoinCondition();
    }

    @Override
    void addJoinCondition(Expression expression) {
        super.addJoinCondition(expression);
    }

    @Override
    void resetConditions() {
        super.resetConditions();
    }

    @Override
    OrderedHashSet getSubqueries() {
        return super.getSubqueries();
    }

    @Override
    public void replaceColumnReference(RangeVariable rangeVariable, Expression[] expressionArray) {
    }

    @Override
    public void replaceRangeVariables(RangeVariable[] rangeVariableArray, RangeVariable[] rangeVariableArray2) {
        super.replaceRangeVariables(rangeVariableArray, rangeVariableArray2);
    }

    @Override
    public void resolveRangeTable(Session session, RangeVariable[] rangeVariableArray, int n, RangeVariable[] rangeVariableArray2) {
        super.resolveRangeTable(session, rangeVariableArray, n, RangeVariable.emptyArray);
    }

    @Override
    public String describe(Session session, int n) {
        RangeVariable.RangeVariableConditions[] rangeVariableConditionsArray = this.joinConditions;
        String string = ValuePool.spaceString.substring(0, n);
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = "INNER";
        if (this.isLeftJoin) {
            string2 = "LEFT OUTER";
            if (this.isRightJoin) {
                string2 = "FULL";
            }
        } else if (this.isRightJoin) {
            string2 = "RIGHT OUTER";
        }
        stringBuffer.append(string).append("join type=").append(string2).append("\n");
        stringBuffer.append(string).append("table=").append(this.rangeTable.getName().name).append("\n");
        if (this.tableAlias != null) {
            stringBuffer.append(string).append("alias=").append(this.tableAlias.name).append("\n");
        }
        boolean bl = !rangeVariableConditionsArray[0].hasIndexCondition();
        stringBuffer.append(string).append("access=").append(bl ? "FULL SCAN" : "INDEX PRED").append("\n");
        for (int i = 0; i < rangeVariableConditionsArray.length; ++i) {
            RangeVariable.RangeVariableConditions rangeVariableConditions = this.joinConditions[i];
            if (i > 0) {
                stringBuffer.append(string).append("OR condition = [");
            } else {
                stringBuffer.append(string).append("condition = [");
            }
            stringBuffer.append(rangeVariableConditions.describe(session, n + 2));
            stringBuffer.append(string).append("]\n");
        }
        return stringBuffer.toString();
    }

    @Override
    public RangeVariable.RangeIteratorMain getIterator(Session session) {
        return super.getIterator(session);
    }
}

