/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.util.SortedSet;
import java.util.TreeSet;
import schemacrawler.crawl.AbstractNamedObject;
import schemacrawler.crawl.MutableForeignKeyColumnMap;
import schemacrawler.schema.Column;
import schemacrawler.schema.ForeignKey;
import schemacrawler.schema.ForeignKeyColumnMap;
import schemacrawler.schema.ForeignKeyDeferrability;
import schemacrawler.schema.ForeignKeyUpdateRule;
import schemacrawler.schema.NamedObject;

class MutableForeignKey
extends AbstractNamedObject
implements ForeignKey {
    private static final long serialVersionUID = 4121411795974895671L;
    private final SortedSet<MutableForeignKeyColumnMap> columnPairs = new TreeSet<MutableForeignKeyColumnMap>();
    private ForeignKeyUpdateRule updateRule = ForeignKeyUpdateRule.unknown;
    private ForeignKeyUpdateRule deleteRule = ForeignKeyUpdateRule.unknown;
    private ForeignKeyDeferrability deferrability = ForeignKeyDeferrability.unknown;

    MutableForeignKey(String name) {
        super(name);
    }

    @Override
    public int compareTo(NamedObject obj) {
        if (obj == null) {
            return -1;
        }
        ForeignKey other = (ForeignKey)obj;
        int comparison = 0;
        ForeignKeyColumnMap[] thisColumnPairs = this.getColumnPairs();
        ForeignKeyColumnMap[] otherColumnPairs = other.getColumnPairs();
        if (comparison == 0) {
            comparison = thisColumnPairs.length - otherColumnPairs.length;
        }
        if (comparison == 0) {
            for (int i = 0; i < thisColumnPairs.length; ++i) {
                ForeignKeyColumnMap thisColumnPair = thisColumnPairs[i];
                ForeignKeyColumnMap otherColumnPair = otherColumnPairs[i];
                if (comparison != 0) break;
                comparison = thisColumnPair.compareTo(otherColumnPair);
            }
        }
        return comparison;
    }

    @Override
    public ForeignKeyColumnMap[] getColumnPairs() {
        return this.columnPairs.toArray(new ForeignKeyColumnMap[this.columnPairs.size()]);
    }

    @Override
    public final ForeignKeyDeferrability getDeferrability() {
        return this.deferrability;
    }

    @Override
    public final ForeignKeyUpdateRule getDeleteRule() {
        return this.deleteRule;
    }

    @Override
    public final ForeignKeyUpdateRule getUpdateRule() {
        return this.updateRule;
    }

    void addColumnPair(int keySequence, Column pkColumn, Column fkColumn) {
        MutableForeignKeyColumnMap fkColumnPair = new MutableForeignKeyColumnMap();
        fkColumnPair.setKeySequence(keySequence);
        fkColumnPair.setPrimaryKeyColumn(pkColumn);
        fkColumnPair.setForeignKeyColumn(fkColumn);
        this.columnPairs.add(fkColumnPair);
    }

    final void setDeferrability(ForeignKeyDeferrability deferrability) {
        this.deferrability = deferrability;
    }

    final void setDeleteRule(ForeignKeyUpdateRule deleteRule) {
        this.deleteRule = deleteRule;
    }

    final void setUpdateRule(ForeignKeyUpdateRule updateRule) {
        this.updateRule = updateRule;
    }
}

