/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.commandline;

import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import schemacrawler.schemacrawler.Config;
import schemacrawler.tools.commandline.ApplicationOptionsParser;
import schemacrawler.tools.commandline.CommandLine;
import schemacrawler.tools.commandline.SchemaCrawlerCommandLine;
import schemacrawler.tools.commandline.SchemaCrawlerHelpCommandLine;
import schemacrawler.tools.options.ApplicationOptions;
import schemacrawler.tools.options.BundledDriverOptions;
import schemacrawler.tools.options.HelpOptions;

public class SchemaCrawlerMain {
    private static final Logger LOGGER = Logger.getLogger(SchemaCrawlerMain.class.getName());

    public static void main(String[] args) throws Exception {
        SchemaCrawlerMain.main(args, new HelpOptions(), null);
    }

    public static void main(String[] args, BundledDriverOptions bundledDriverOptions) throws Exception {
        if (bundledDriverOptions == null) {
            throw new IllegalArgumentException("No bundled driver options provided");
        }
        SchemaCrawlerMain.main(args, bundledDriverOptions.getHelpOptions(), bundledDriverOptions.getConfig());
    }

    public static void main(String[] args, HelpOptions helpOptions, Config config) throws Exception {
        boolean showHelp;
        ApplicationOptions applicationOptions;
        String[] remainingArgs = args;
        if (remainingArgs.length == 0) {
            applicationOptions = new ApplicationOptions();
            showHelp = true;
        } else {
            ApplicationOptionsParser applicationOptionsParser = new ApplicationOptionsParser();
            remainingArgs = applicationOptionsParser.parse(remainingArgs);
            applicationOptions = applicationOptionsParser.getOptions();
            showHelp = applicationOptions.isShowHelp();
        }
        applicationOptions.applyApplicationLogLevel();
        LOGGER.log(Level.CONFIG, "Command line: " + Arrays.toString(args));
        CommandLine commandLine = showHelp ? new SchemaCrawlerHelpCommandLine(remainingArgs, helpOptions) : new SchemaCrawlerCommandLine(config, remainingArgs);
        commandLine.execute();
    }

    private SchemaCrawlerMain() {
    }
}

