/*
 * Copyright 2008-2009 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package javarequirementstracer.systemtest;

import javarequirementstracer.Requirements;

/**
 * Very special 'test class': all it needs to do is to exist, to allow Maven to launch the 
 * goals "trace" and "aggregate". The test succeeds if Maven doesn't break. Hence it can
 * only be tested by running Maven (eg. mvn install). 
 * 
 * @author Ruud de Jong
 */
@Requirements({"UC-Goal-Aggregate", "UC-Goal-Trace", "UC-No-Spring"})
public class NoSpring {
	
	public static void main(String[] args) {
		System.out.println("NoSpring");
	}
}