/*
 * Copyright 2008-2009 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package javarequirementstracer.systemtest;

import javarequirementstracer.Requirements;

import org.junit.Test;


/**
 * @author Ronald Koster
 */
public class PluginTest {
	
	@Test
	@Requirements("UC-Goal-Aggregate")
	public void ucGoalAggregate() {
		// Can only be tested through an actual mvn run., which is done manually.
	}
	
	@Test
	@Requirements("UC-Goal-Trace")
	public void ucGoalTrace() {
		// Idem as at ucGoalAggregate.
	}
	
	@Test
	@Requirements("UC-No-Spring")
	public void ucNoSpring() {
		// Is tested by jrt-system-test-no-spring project. 
	}
}