/*
 * Decompiled with CFR 0.152.
 */
package javarequirementstracer;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import javarequirementstracer.AttributeId;
import javarequirementstracer.FileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class XhtmlBuilder {
    private static final String TABLE_START = "\n<table border='1' cellspacing='0' cellpadding='3'";
    private static final String TABLE_END = "\n</table>";
    private static final String ROW_START = "\n<tr>";
    private static final String ROW_END = "\n</tr>";
    private static final String HEADER_START = "\n<th>";
    private static final String HEADER_END = "</th>";
    private static final String COLUMN_START = "\n<td>";
    private static final String COLUMN_END = "</td>";
    private static final String PAR_START = "\n<p>\n";
    private static final String PAR_END = "\n</p>";
    private static final String BR = "\n<br/>";
    private static final String SPACE = " ";
    static final String NBSP = "&nbsp;";
    private static final String TAB = "&nbsp;&nbsp;&nbsp;&nbsp;";
    static final String SPAN_END = "</span>";
    private static final String STYLE = "\n<style type='text/css'>\ndiv.percentgraph {\n    background-color: #f02020;\n    border: #808080 1px solid;\n    height: 1.3em;\n    magin: 0px;\n    padding: 0px;\n}\ndiv.greenbar {\n    background-color: #00f000;\n    height: 1.3em;\n    magin: 0px;\n    padding: 0px;\n}\n</style>";
    private final StringBuilder bldr = new StringBuilder();
    private boolean parStarted = false;

    XhtmlBuilder() {
    }

    public String toString() {
        return this.bldr.toString();
    }

    XhtmlBuilder append(Object obj) {
        this.bldr.append(obj);
        return this;
    }

    XhtmlBuilder append(AttributeId spanId, Object obj) {
        return this.spanStart(spanId).append(obj).spanEnd();
    }

    XhtmlBuilder start(String title) {
        this.append("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">");
        return this.append("\n<html>\n<head>\n<title>").append(title).append("</title>").append(STYLE).append("\n</head>\n<body>").heading(1, title);
    }

    XhtmlBuilder end() {
        return this.append("\n\n</body>\n</html>");
    }

    XhtmlBuilder heading(int level, String title) {
        return this.append("\n\n<h").append(level).append(">").append(title).append("</h").append(level).append(">");
    }

    XhtmlBuilder parStart() {
        if (this.parStarted) {
            throw new IllegalStateException("Paragraph not ended yet.");
        }
        this.parStarted = true;
        return this.append(PAR_START);
    }

    XhtmlBuilder parEnd() {
        if (!this.parStarted) {
            throw new IllegalStateException("Paragraph not started yet.");
        }
        this.parStarted = false;
        return this.append(PAR_END);
    }

    XhtmlBuilder spanStart(AttributeId id) {
        this.bldr.append("<span");
        return this.attId(id);
    }

    XhtmlBuilder spanEnd() {
        this.bldr.append(SPAN_END);
        return this;
    }

    private XhtmlBuilder attId(AttributeId id) {
        this.bldr.append(" id='").append((Object)id).append("'>");
        return this;
    }

    XhtmlBuilder br() {
        return this.append(BR);
    }

    XhtmlBuilder space() {
        return this.append(SPACE);
    }

    XhtmlBuilder nbsp() {
        return this.append(NBSP);
    }

    XhtmlBuilder tab() {
        return this.append(TAB);
    }

    XhtmlBuilder table(AttributeId id, Map<String, String> map, String ... headers) {
        ArrayList<Collection<String>> rows = new ArrayList<Collection<String>>();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            ArrayList<String> row = new ArrayList<String>();
            row.add(entry.getKey());
            row.add(entry.getValue());
            rows.add(row);
        }
        return this.table(id, rows, headers);
    }

    XhtmlBuilder table(AttributeId id, Collection<Collection<String>> rows, String ... headers) {
        this.validateTrue("At least rows or headers must not be empty.", rows != null && rows.size() > 0 || headers != null && headers.length > 0);
        this.bldr.append(TABLE_START);
        this.attId(id);
        if (headers != null && headers.length > 0) {
            this.appendHeaders(headers);
        }
        if (rows != null) {
            this.appendRows(rows);
        }
        return this.append(TABLE_END);
    }

    private void appendHeaders(String ... headers) {
        this.append(ROW_START);
        for (String header : headers) {
            this.append(HEADER_START).append(header).append(HEADER_END);
        }
        this.append(ROW_END);
    }

    private void appendRows(Collection<Collection<String>> rows) {
        for (Collection<String> row : rows) {
            this.append(ROW_START);
            for (String column : row) {
                this.append(COLUMN_START);
                this.append(column == null || column.length() == 0 ? NBSP : column);
                this.append(COLUMN_END);
            }
            this.append(ROW_END);
        }
    }

    void write(File reportFile) {
        FileUtils.writeFile(reportFile, this.toString());
    }

    private void validateTrue(String msg, boolean condition) {
        if (!condition) {
            throw new IllegalArgumentException(msg);
        }
    }
}

