/*
 * Copyright 2008-2009 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package javarequirementstracer;

import java.io.File;

import junit.framework.Assert;

import org.junit.Test;


/**
 * @author Ronald Koster
 */
public class FileUtilsTest {
	
	@Test
	public void all() {
		final String text = "blabla etc blabla etc etc";
		final String filename1 = "target/file1.txt";
		FileUtils.writeFile(filename1, text);
		final String filename2 = "target/subdir/file1.txt";
		FileUtils.copyFile(new File(filename1), new File(filename2));
		String actual = FileUtils.readFileAsString(filename2);
		Assert.assertEquals(text, actual);
	}
}