/*
 * Decompiled with CFR 0.152.
 */
package javarequirementstracer;

import java.lang.reflect.Modifier;
import java.util.HashSet;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javarequirementstracer.AbstractScanner;
import javarequirementstracer.ClassPathScanner;
import javarequirementstracer.Requirements;
import javarequirementstracer.SuppressTraceabilityWarnings;
import javarequirementstracer.TraceProperties;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.AssignableTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.util.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class UntraceableScanner
extends AbstractScanner {
    UntraceableScanner(TraceProperties properties) {
        super(properties);
    }

    SortedSet<String> run() {
        TreeSet<String> typeNames = new TreeSet<String>();
        for (Class<?> cl : this.getTypes(this.getProperties().getIncludePackageNames())) {
            int modifiers;
            if (this.exclude(cl) || !Modifier.isPublic(modifiers = cl.getModifiers()) && !Modifier.isProtected(modifiers)) continue;
            String typeName = this.getProperties().getShortTypeName(cl.getName());
            typeNames.add(typeName);
        }
        return typeNames;
    }

    private Set<Class<?>> getTypes(Set<String> packageNames) {
        HashSet list = new HashSet();
        ClassPathScanner scanner = new ClassPathScanner(false);
        this.setResourceLoader(scanner);
        scanner.addIncludeFilter((TypeFilter)new AssignableTypeFilter(Object.class));
        scanner.addExcludeFilter((TypeFilter)new AnnotationTypeFilter(Requirements.class));
        scanner.addExcludeFilter((TypeFilter)new AnnotationTypeFilter(SuppressTraceabilityWarnings.class));
        for (String basePackageName : packageNames) {
            Set components = scanner.findCandidateComponents(basePackageName);
            for (BeanDefinition component : components) {
                String className = component.getBeanClassName();
                Class cl = ClassUtils.resolveClassName((String)className, (ClassLoader)this.getClassLoader());
                list.add(cl);
            }
        }
        return list;
    }
}

