/*
 * Decompiled with CFR 0.152.
 */
package javarequirementstracer;

import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import javarequirementstracer.AbstractScanner;
import javarequirementstracer.ClassPathScanner;
import javarequirementstracer.Requirements;
import javarequirementstracer.TraceProperties;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.util.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class RequirementsScanner
extends AbstractScanner {
    static final String METHOD_SEPARATOR = "#";

    RequirementsScanner(TraceProperties properties) {
        super(properties);
    }

    SortedMap<String, SortedSet<String>> run() {
        TreeMap<String, SortedSet<String>> codeNamesTo = new TreeMap<String, SortedSet<String>>();
        for (Class<?> cl : this.getTypes(this.getProperties().getIncludePackageNames())) {
            Requirements reqs;
            if (this.exclude(cl)) continue;
            if (cl.isAnnotationPresent(Requirements.class)) {
                Requirements reqs2 = cl.getAnnotation(Requirements.class);
                this.addLabels(codeNamesTo, cl, reqs2);
            }
            for (Constructor<?> constructor : cl.getDeclaredConstructors()) {
                if (!constructor.isAnnotationPresent(Requirements.class)) continue;
                reqs = constructor.getAnnotation(Requirements.class);
                this.addLabels(codeNamesTo, constructor, reqs);
            }
            for (Executable executable : cl.getDeclaredMethods()) {
                if (!executable.isAnnotationPresent(Requirements.class)) continue;
                reqs = ((Method)executable).getAnnotation(Requirements.class);
                this.addLabels(codeNamesTo, executable, reqs);
            }
        }
        return codeNamesTo;
    }

    private Set<Class<?>> getTypes(Set<String> packageNames) {
        HashSet list = new HashSet();
        ClassPathScanner scanner = new ClassPathScanner(false);
        this.setResourceLoader(scanner);
        scanner.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(Requirements.class));
        for (String basePackageName : packageNames) {
            Set components = scanner.findCandidateComponents(basePackageName);
            for (BeanDefinition component : components) {
                String className = component.getBeanClassName();
                list.add(ClassUtils.resolveClassName((String)className, (ClassLoader)this.getClassLoader()));
            }
        }
        return list;
    }

    private <T> void addLabels(Map<String, SortedSet<String>> codeNamesToLabels, T type, Requirements reqs) {
        Set<String> labels = this.getLabels(codeNamesToLabels, type);
        labels.addAll(Arrays.asList(reqs.value()));
    }

    private <T> Set<String> getLabels(Map<String, SortedSet<String>> codeNamesToLabels, T type) {
        String typeName = this.getProperties().getShortTypeName(this.getTypeName(type));
        SortedSet<String> set = codeNamesToLabels.get(typeName);
        if (set == null) {
            set = new TreeSet<String>();
            codeNamesToLabels.put(typeName, set);
        }
        return set;
    }

    private String getTypeName(Object type) {
        if (type instanceof Class) {
            Class cl = (Class)type;
            return cl.getName();
        }
        if (type instanceof Constructor) {
            Constructor con = (Constructor)type;
            String name = con.getName();
            int index = name.lastIndexOf(46);
            return name + METHOD_SEPARATOR + name.substring(index + 1);
        }
        if (type instanceof Method) {
            Method meth = (Method)type;
            return meth.getDeclaringClass().getName() + METHOD_SEPARATOR + meth.getName();
        }
        throw new IllegalArgumentException("type=" + type);
    }
}

