/*
 * Decompiled with CFR 0.152.
 */
package javarequirementstracer;

import java.io.IOException;
import java.text.DecimalFormatSymbols;
import java.util.Date;
import java.util.Properties;
import javarequirementstracer.AttributeId;
import javarequirementstracer.SuppressTraceabilityWarnings;
import javarequirementstracer.UncheckedException;
import javarequirementstracer.XhtmlBuilder;

@SuppressTraceabilityWarnings
public final class ReporterUtils {
    static final String CODE_COVERAGE_DEF = "= traceableTypeCount/allTypesCount = ";
    static final String REQUIREMENTS_COVERAGE_DEF = "= (foundLabelCount - unknownLabelCount)/requiredLabelCount = ";

    private ReporterUtils() {
    }

    static void appendReporterInfo(XhtmlBuilder bldr) {
        bldr.append("<small>Generated with ").spanStart(AttributeId.REPORTER_INFO);
        bldr.append("<a href='http://reqtracer.sourceforge.net'>JavaRequirementsTracer</a> ").append(ReporterUtils.getVersion());
        bldr.spanEnd().append(".</small>");
    }

    static void appendTimestampBuildNumber(XhtmlBuilder bldr, String buildNr) {
        bldr.parStart();
        bldr.append("<b>Timestamp:</b> ").append(AttributeId.TIMESTAMP, new Date());
        bldr.br().append("\n<b>Build Number:</b> ").append(AttributeId.BUILD_NUMBER, buildNr == null ? "???" : buildNr);
        bldr.parEnd();
    }

    static void appendProgressIndicatorEstimate(XhtmlBuilder bldr, boolean total) {
        String prefix = total ? "Total" : "";
        bldr.parStart().append("<b>").append(prefix).append(" Completeness estimates:</b>").parEnd();
        bldr.append("\n<ol>");
        bldr.append("\n<li>Best choice: ").append(prefix).append("Completeness").nbsp().append("=").nbsp().append(prefix).append("SytemTestCodeRequirementsCoverage").nbsp().append("*").nbsp().append(prefix).append("PercentageSuccessfulSystemTests</li>");
        bldr.append("\n<li>Next best choice (no System Test code): ").append(prefix).append("Completeness").nbsp().append("=").nbsp().append(prefix).append("MainCodeRequirementsCoverage").nbsp().append("*").nbsp().append(prefix).append("PercentageSuccessfulManualSystemTests</li>");
        bldr.append("\n</ol>");
    }

    private static String getVersion() {
        Properties props = new Properties();
        try {
            props.load(ReporterUtils.class.getResourceAsStream("/jrt-reporter.properties"));
        }
        catch (IOException ioex) {
            throw new UncheckedException(ioex);
        }
        return props.getProperty("version");
    }

    public static String formatPercentage(double d) {
        return String.format("%.2f", 100.0 * d) + "%";
    }

    public static String formatPercentage(String integerPart, String fraction) {
        return integerPart + ReporterUtils.getDecimalSeparator() + fraction + "%";
    }

    public static char getDecimalSeparator() {
        return DecimalFormatSymbols.getInstance().getDecimalSeparator();
    }

    static String getPercentageGraph(double coverage) {
        return ReporterUtils.getPercentageGraph(coverage, 1.0, 100.0);
    }

    static String getPercentageGraph(double coverage, double weigth, double width) {
        return "<div class='percentgraph' style='width:" + Math.round(weigth * width) + "px;'>" + "<div class='greenbar' style='width:" + Math.round(weigth * coverage * width) + "px;'/></div>";
    }
}

