/*
 * Decompiled with CFR 0.152.
 */
package javarequirementstracer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class Logger {
    private final String name;

    private Logger(String name) {
        this.name = name;
    }

    static Logger getInstance(String name) {
        return new Logger(name);
    }

    static Logger getInstance(Class<?> clazz) {
        return Logger.getInstance(clazz.getName());
    }

    void debug(String str) {
        this.debug(str, null);
    }

    void debug(String str, Throwable th) {
        this.log("DEBUG ", str, th);
    }

    void info(String str) {
        this.log("INFO ", str);
    }

    void warn(String str) {
        this.log("WARN ", str);
    }

    void error(String str) {
        this.error(str, null);
    }

    void error(Throwable th) {
        this.error("Unexpected exception in " + this.name, th);
    }

    void error(String str, Throwable th) {
        this.log("ERROR ", str, th);
    }

    private void log(String prefix, String msg) {
        this.log(prefix, msg, null);
    }

    private void log(String prefix, String msg, Throwable th) {
        Logger.println(prefix + msg);
        if (th != null) {
            th.printStackTrace();
        }
    }

    static void println(String str) {
        System.out.println(str);
    }
}

