/*
 * Decompiled with CFR 0.152.
 */
package javarequirementstracer;

import java.util.SortedMap;
import java.util.SortedSet;
import javarequirementstracer.Logger;
import javarequirementstracer.Requirements;
import javarequirementstracer.RequirementsScanner;
import javarequirementstracer.TraceProperties;
import javarequirementstracer.TraceReporter;
import javarequirementstracer.UntraceableScanner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Requirements(value={"UC-Generate-Report"})
public final class JavaRequirementsTracerBean {
    private static final Logger LOGGER = Logger.getInstance(JavaRequirementsTracerBean.class);
    private String paramsFilename;
    private String buildNumber;
    private ClassLoader classLoader;
    private final TraceProperties properties = new TraceProperties();

    public String getParamsFilename() {
        return this.paramsFilename;
    }

    public void setParamsFilename(String paramsFilename) {
        this.paramsFilename = paramsFilename;
    }

    public String getExpectedLabelsFilename() {
        return this.properties.getExpectedLabelsFilename();
    }

    public String getReportFilename() {
        return this.properties.getReportFilename();
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public void setBuildNumber(String buildNumber) {
        this.buildNumber = buildNumber;
    }

    public void init() {
        this.properties.loadParams(this.paramsFilename);
        this.properties.setBuildNumber(this.buildNumber);
        this.properties.setClassLoader(this.classLoader);
    }

    public void run() {
        this.init();
        SortedMap<String, SortedSet<String>> codeNamesToLabels = this.scanRequirements();
        SortedSet<String> untraceableTypes = this.scanUntraceable();
        this.write(codeNamesToLabels, untraceableTypes);
    }

    public SortedMap<String, SortedSet<String>> scanRequirements() {
        this.validate();
        RequirementsScanner scanner = new RequirementsScanner(this.properties);
        return scanner.run();
    }

    public SortedSet<String> scanUntraceable() {
        this.validate();
        UntraceableScanner scanner = new UntraceableScanner(this.properties);
        return scanner.run();
    }

    public void write(SortedMap<String, SortedSet<String>> codeNamesToLabels, SortedSet<String> untraceableTypes) {
        TraceReporter reporter = new TraceReporter(this.properties, codeNamesToLabels, untraceableTypes);
        reporter.run();
    }

    private void validate() {
        if (this.properties == null) {
            throw new IllegalStateException("Not initialized yet.");
        }
    }
}

