/*
 * Decompiled with CFR 0.152.
 */
package javarequirementstracer;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javarequirementstracer.SuppressTraceabilityWarnings;
import javarequirementstracer.UncheckedException;

@SuppressTraceabilityWarnings
public final class FileUtils {
    private static final String BACKSLASH = "\\";
    private static final String SLASH = "/";

    private FileUtils() {
    }

    public static String readFileAsString(String filename) {
        return new String(FileUtils.readFileAsBytes(filename));
    }

    public static String readFileAsString(File file) {
        return new String(FileUtils.readFileAsBytes(file));
    }

    public static byte[] readFileAsBytes(String filename) {
        return FileUtils.readFileAsBytes(new File(filename));
    }

    public static byte[] readFileAsBytes(File file) {
        FileInputStream in;
        try {
            in = new FileInputStream(file);
        }
        catch (FileNotFoundException ex) {
            throw new UncheckedException(ex);
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        FileUtils.copyStream(in, out);
        return out.toByteArray();
    }

    public static void writeFile(String filename, String str) {
        FileUtils.writeFile(filename, str.getBytes());
    }

    public static void writeFile(File file, String str) {
        FileUtils.writeFile(file, str.getBytes());
    }

    public static void writeFile(String filename, byte[] bytes) {
        FileUtils.writeFile(new File(filename), bytes);
    }

    public static void writeFile(File file, byte[] bytes) {
        FileOutputStream out;
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        try {
            boolean success;
            if (!file.getParentFile().exists() && !(success = file.getParentFile().mkdirs())) {
                throw new UncheckedException(new IOException("Failed to create " + file.getParentFile().getPath()));
            }
            out = new FileOutputStream(file);
        }
        catch (FileNotFoundException ex) {
            throw new UncheckedException(ex);
        }
        FileUtils.copyStream(in, out);
    }

    public static void copyStream(InputStream in, OutputStream out) {
        try {
            int b = in.read();
            while (b > -1) {
                out.write(b);
                b = in.read();
            }
            in.close();
            out.close();
        }
        catch (IOException ex) {
            throw new UncheckedException(ex);
        }
    }

    public static boolean exists(String filename) {
        return new File(filename).exists();
    }

    public static String getAbsolutePath(String filename) {
        File file = new File(filename);
        return FileUtils.replaceBackslash(file.getAbsolutePath());
    }

    public static String getCanonicalPath(String filename) {
        File file = new File(filename);
        try {
            return FileUtils.replaceBackslash(file.getCanonicalPath());
        }
        catch (IOException ex) {
            throw new UncheckedException(ex);
        }
    }

    public static boolean isAbsolute(String filename) {
        File file = new File(filename);
        return file.isAbsolute();
    }

    public static String getParent(String filename) {
        File file = new File(filename);
        return FileUtils.replaceBackslash(file.getParent());
    }

    private static String replaceBackslash(String str) {
        return str.replace(BACKSLASH, SLASH);
    }

    public static int assertPresent(String content, int index1, int index2, String ... strings) {
        FileUtils.validateArgs(index1, strings);
        int index = -1;
        for (String str : strings) {
            index = content.indexOf(str, index1);
            FileUtils.assertTrue("Expected: index1 <= index for " + str + ", index1=" + index1 + ", index=" + index, index1 <= index);
            if (index2 < 0) continue;
            FileUtils.assertTrue("Expected: index < index2 for " + str + ", index=" + index + ", index2=" + index2, index < index2);
        }
        return index;
    }

    public static void assertNotPresent(String content, int index1, int index2, String ... strings) {
        FileUtils.validateArgs(index1, strings);
        for (String str : strings) {
            int index = content.indexOf(str, index1);
            FileUtils.assertTrue("Expected: index < 0 || index >= index2 for " + str + ", index=" + index + ", index1=" + index1 + ", index2=" + index2, index < 0 || index >= index2);
        }
    }

    private static void validateArgs(int index1, String[] strings) {
        FileUtils.assertTrue("Expected: index1 >= 0, index1=" + index1, index1 >= 0);
        FileUtils.assertTrue("Expected: strings.length > 0", strings.length > 0);
    }

    private static void assertTrue(String msg, boolean condition) {
        if (!condition) {
            throw new IllegalArgumentException(msg);
        }
    }
}

