/*
 * Decompiled with CFR 0.152.
 */
package javarequirementstracer;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Collection;
import javarequirementstracer.AttributeId;
import javarequirementstracer.FileUtils;
import javarequirementstracer.JavaRequirementsTracer;
import javarequirementstracer.Logger;
import javarequirementstracer.ReporterUtils;
import javarequirementstracer.Requirements;
import javarequirementstracer.UniqueProperties;
import javarequirementstracer.XhtmlBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Requirements(value={"UC-Overview-Report"})
public final class ReportAggregator {
    private static final Logger LOGGER = Logger.getInstance(ReportAggregator.class);
    private static final String DEFAULT_OVERVIEW_PARAMS_MAIN_FILENAME = "src/test/config/traceability_overview_params_main.properties";
    private static final String DEFAULT_OVERVIEW_PARAMS_SYSTEM_TEST_FILENAME = "src/test/config/traceability_overview_params_system_test.properties";
    public static final String DEFAULT_OVERVIEW_PARAMS_FILENAMES = "src/test/config/traceability_overview_params_main.properties, src/test/config/traceability_overview_params_system_test.properties";
    public static final String USAGE = "Usage: java " + ReportAggregator.class.getName() + " [<overviewParamsFilenames>]" + "\n\nWith:" + "\n<overviewParamsFilenames>: Comma separated list of properties filenames each containing all" + "\n                           parameters for a report For each a report will be generated." + "\n                           Default: " + "src/test/config/traceability_overview_params_main.properties, src/test/config/traceability_overview_params_system_test.properties" + "." + "\n                           See also the comments in the properties file itself." + "\n                           For an example see:" + "\n                              + " + "src/test/config/traceability_overview_params_main.properties" + "\n                              + " + "src/test/config/traceability_overview_params_system_test.properties";
    private static final double GRAPH_WIDTH = 150.0;
    private String overviewParamsFilename;
    private String overviewName;
    private String[] reportFilenames;
    private String outputFilename = "../../../target/traceability_overview.html";

    public void setOverviewParamsFilename(String overviewParamsFilename) {
        this.overviewParamsFilename = overviewParamsFilename;
    }

    public static void main(String[] args) {
        ReportAggregator agg = new ReportAggregator();
        if (agg.helpRequested(args)) {
            System.out.println(USAGE);
            System.exit(1);
        }
        String paramsFilenames = DEFAULT_OVERVIEW_PARAMS_FILENAMES;
        if (args.length >= 1) {
            paramsFilenames = args[0];
        }
        try {
            String[] arr$ = JavaRequirementsTracer.split(paramsFilenames);
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                String paramsFilename;
                agg.overviewParamsFilename = paramsFilename = arr$[i$];
                agg.run();
            }
        }
        catch (FileNotFoundException ex) {
            LOGGER.info("No report generated. " + ex.getMessage());
            System.exit(2);
        }
    }

    private boolean helpRequested(String[] args) {
        return args.length == 1 && (args[0].equals("-h") || args[0].equals("-help") || args[0].equals("--help"));
    }

    public void run() throws FileNotFoundException {
        this.init();
        double totalCodeCoverage = 0.0;
        double totalRequirementsCoverage = 0.0;
        double totalLabelCount = 0.0;
        XhtmlBuilder bldr = new XhtmlBuilder();
        bldr.start("Traceability Overview for " + this.overviewName);
        ReporterUtils.appendReporterInfo(bldr);
        ArrayList<WorkTableRow> workTable = new ArrayList<WorkTableRow>();
        for (int i = 0; i < this.reportFilenames.length; ++i) {
            String reportFilename = this.reportFilenames[i];
            String report = FileUtils.readFileAsString(reportFilename);
            if (i == 0) {
                String buildNr = this.substring(report, "<span id='" + (Object)((Object)AttributeId.BUILD_NUMBER) + "'>", "</span>");
                ReporterUtils.appendTimestampBuildNumber(bldr, buildNr + " <small>(from first report below)</small>");
            }
            String reportName = this.extractReportName(report);
            double codeCoverage = this.extractCodeCoverage(report);
            double requirementsCoverage = this.extractRequirementsCoverage(report);
            double labelCount = this.extractLabelCount(report);
            if (!Double.isNaN(codeCoverage)) {
                totalCodeCoverage += labelCount * codeCoverage;
            }
            totalRequirementsCoverage += labelCount * requirementsCoverage;
            totalLabelCount += labelCount;
            workTable.add(new WorkTableRow(false, "<a href='" + this.getLinkFilename(reportFilename) + "'>" + reportName + "</a>", codeCoverage, requirementsCoverage, labelCount));
        }
        WorkTableRow totalsRow = new WorkTableRow(true, "Total", totalCodeCoverage /= totalLabelCount, totalRequirementsCoverage /= totalLabelCount, totalLabelCount);
        workTable.add(totalsRow);
        ArrayList<Collection<String>> reportTable = new ArrayList<Collection<String>>();
        for (WorkTableRow row : workTable) {
            double weight = row.getLabelCount() / totalLabelCount;
            reportTable.add(this.convertRow(row, weight));
        }
        bldr.table(AttributeId.COVERAGES, reportTable, "Module", "CodeCoverage", "RequirementsCoverage", "RequirementsCount", "Weight");
        ReporterUtils.appendProgressIndicatorEstimate(bldr, true);
        bldr.end();
        String overview = bldr.toString();
        overview = overview.replace("<td>", "<td align='right'>");
        overview = overview.replace("<tr>\n<td align='right'>", "<tr>\n<td>");
        overview = overview.replace("<th>CodeCoverage", "<th colspan='2'>CodeCoverage");
        overview = overview.replace("<th>RequirementsCoverage", "<th colspan='2'>RequirementsCoverage");
        overview = overview.replace("<td align='right'><div", "<td><div");
        overview = overview.replace("<td align='right'><b><div", "<td><b><div");
        FileUtils.writeFile(this.outputFilename, overview);
        LOGGER.info("Overview written to: " + this.outputFilename);
    }

    private void init() throws FileNotFoundException {
        File paramsFile = new File(this.overviewParamsFilename);
        if (!paramsFile.exists()) {
            throw new FileNotFoundException("File not found: " + this.overviewParamsFilename);
        }
        UniqueProperties props = new UniqueProperties();
        props.load(paramsFile);
        this.overviewName = props.getProperty("overview.name");
        String baseDir = paramsFile.getParent() + "/";
        this.reportFilenames = JavaRequirementsTracer.split(props.getProperty("report.filenames"));
        for (int i = 0; i < this.reportFilenames.length; ++i) {
            if (FileUtils.isAbsolute(this.reportFilenames[i])) continue;
            this.reportFilenames[i] = baseDir + this.reportFilenames[i];
        }
        this.outputFilename = props.getProperty("output.filename", this.outputFilename);
        if (!FileUtils.isAbsolute(this.outputFilename)) {
            this.outputFilename = baseDir + this.outputFilename;
        }
    }

    private String extractReportName(String str) {
        return this.substring(str, "<title>Traceabilities for", "</title>").trim();
    }

    private double extractCodeCoverage(String str) {
        double[] fraction = this.extractFraction(str, "= traceableTypeCount/allTypesCount = ", "</span>");
        return fraction[0] / fraction[1];
    }

    private double extractRequirementsCoverage(String str) {
        double[] fraction = this.extractFraction(str, "= (foundLabelCount - unknownLabelCount)/requiredLabelCount = ", "</span>");
        return fraction[0] / fraction[1];
    }

    private double extractLabelCount(String str) {
        double[] fraction = this.extractFraction(str, "= (foundLabelCount - unknownLabelCount)/requiredLabelCount = ", "</span>");
        return fraction[1];
    }

    private double[] extractFraction(String str, String str1, String str2) {
        String fraction = this.substring(str, str1, str2).trim();
        int index = fraction.indexOf(47);
        double[] result = new double[]{Double.valueOf(fraction.substring(0, index)), Double.valueOf(fraction.substring(index + 1))};
        return result;
    }

    private String substring(String str, String str1, String str2) {
        int index1 = str.indexOf(str1);
        int index2 = str.indexOf(str2, index1);
        return str.substring(index1 + str1.length(), index2);
    }

    private Collection<String> convertRow(WorkTableRow row, double weight) {
        return this.createRow(row.isBold(), row.getName(), ReporterUtils.formatPercentage(row.getCodeCoverage()), ReporterUtils.getPercentageGraph(row.getCodeCoverage(), weight, 150.0), ReporterUtils.formatPercentage(row.getRequirementsCoverage()), ReporterUtils.getPercentageGraph(row.getRequirementsCoverage(), weight, 150.0), String.format("%.0f", row.getLabelCount()), ReporterUtils.formatPercentage(weight));
    }

    private Collection<String> createRow(boolean bold, String ... values) {
        ArrayList<String> row = new ArrayList<String>();
        for (String value : values) {
            if (bold) {
                row.add("<b>" + value + "</b>");
                continue;
            }
            row.add(value);
        }
        return row;
    }

    private String getLinkFilename(String filename) {
        String baseDir = FileUtils.getParent(FileUtils.getCanonicalPath(this.outputFilename));
        String result = FileUtils.getCanonicalPath(filename);
        if (result.startsWith(baseDir)) {
            return result.substring(baseDir.length() + 1);
        }
        return "file:///" + result;
    }

    private static class WorkTableRow {
        private final boolean bold;
        private final String name;
        private final double codeCoverage;
        private final double requirementsCoverage;
        private final double labelCount;

        WorkTableRow(boolean bold, String name, double codeCoverage, double requirementsCoverage, double labelCount) {
            this.bold = bold;
            this.name = name;
            this.codeCoverage = codeCoverage;
            this.requirementsCoverage = requirementsCoverage;
            this.labelCount = labelCount;
        }

        public boolean isBold() {
            return this.bold;
        }

        public String getName() {
            return this.name;
        }

        public double getCodeCoverage() {
            return this.codeCoverage;
        }

        public double getRequirementsCoverage() {
            return this.requirementsCoverage;
        }

        public double getLabelCount() {
            return this.labelCount;
        }
    }
}

