/*
 * Decompiled with CFR 0.152.
 */
package javarequirementstracer;

import javarequirementstracer.JavaRequirementsTracerBean;
import javarequirementstracer.Logger;
import javarequirementstracer.Requirements;

@Requirements(value={"UC-Standalone-Report"})
public final class JavaRequirementsTracer {
    private static final Logger LOGGER = Logger.getInstance(JavaRequirementsTracer.class);
    public static final String DEFAULT_PARAMS_FILENAMES = "src/main/config/traceability_params.properties, src/test/config/traceability_params.properties";
    private static final String PARAMS_FILENAMES_KEY = "params.filenames";
    private static final String BUILD_NUMBER_KEY = "build.number";
    private static final String USAGE = "Usage: java " + JavaRequirementsTracer.class.getName() + " {-<optionName>=<value>}" + "\n\nWith <optionName>: " + "\n    " + "params.filenames" + ": Comma separated list of properties filenames each containing" + "\n                     all tuning parameters for a report. For each a report will generated." + "\n                     Default: " + "src/main/config/traceability_params.properties, src/test/config/traceability_params.properties" + "." + "\n                     See also the comments in the properties file itself." + "\n    " + "build.number" + ": Build number of code to be traced. Default: none.\n";

    private JavaRequirementsTracer() {
    }

    public static void main(String[] args) {
        if (args.length == 1 && (args[0].equals("-h") || args[0].equals("-help") || args[0].equals("--help"))) {
            System.out.println(USAGE);
            return;
        }
        String[] paramsFilenames = JavaRequirementsTracer.split(JavaRequirementsTracer.getOption(args, PARAMS_FILENAMES_KEY, DEFAULT_PARAMS_FILENAMES));
        JavaRequirementsTracerBean tracer = new JavaRequirementsTracerBean();
        tracer.setBuildNumber(JavaRequirementsTracer.getOption(args, BUILD_NUMBER_KEY, null));
        for (String paramsFilename : paramsFilenames) {
            tracer.setParamsFilename(paramsFilename);
            tracer.run();
        }
    }

    private static String getOption(String[] args, String key, String defaultValue) {
        String theKey = "-" + key;
        if (args != null) {
            for (String arg : args) {
                if (!arg.startsWith(theKey)) continue;
                LOGGER.debug("arg=" + arg);
                int index = theKey.length() + 1;
                if (arg.length() <= index) {
                    throw new IllegalArgumentException("Invalid value for option: " + key);
                }
                return arg.substring(index, arg.length());
            }
        }
        return defaultValue;
    }

    public static String[] split(String str) {
        return str.trim().split(",\\s*");
    }
}

